/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class Either<L, R> {
    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract L getLeft();

    public abstract R getRight();

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L left;

        Left(L left) {
            Objects.requireNonNull(left);
            this.left = left;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public L getLeft() {
            return this.left;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("Try to call getRight on Left");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left1 = (Left)o;
            return Objects.equals(this.left, left1.left);
        }

        public int hashCode() {
            return Objects.hash(this.left);
        }

        public String toString() {
            return "left:" + String.valueOf(this.left);
        }
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R right;

        Right(R right) {
            Objects.requireNonNull(right);
            this.right = right;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Try to call getLeft on Right");
        }

        @Override
        public R getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right1 = (Right)o;
            return Objects.equals(this.right, right1.right);
        }

        public int hashCode() {
            return Objects.hash(this.right);
        }

        public String toString() {
            return "right:" + String.valueOf(this.right);
        }
    }
}

