/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class DebouncedConsumer<T> {
    private static final AppLogger LOGGER = new AppLogger(DebouncedConsumer.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Consumer<T> operation;
    private final String name;
    private final long delayMillis;
    private T lastArg = null;
    private boolean isQueued = false;
    private Optional<ScheduledFuture<?>> scheduledTask = Optional.empty();

    public DebouncedConsumer(Consumer<T> operation, String name, long delayMillis) {
        this.operation = operation;
        this.name = name;
        this.delayMillis = delayMillis;
    }

    public synchronized void run(T arg) {
        if (this.isQueued) {
            this.scheduledTask.ifPresent(scheduledFuture -> scheduledFuture.cancel(true));
        } else {
            this.isQueued = true;
        }
        this.lastArg = arg;
        this.scheduledTask = Optional.of(this.scheduler.schedule(this::scheduledRun, this.delayMillis, TimeUnit.MILLISECONDS));
    }

    private synchronized void scheduledRun() {
        LOGGER.trace("calling queued task {} after waiting {} ms", this.name, this.delayMillis);
        this.isQueued = false;
        this.operation.accept(this.lastArg);
    }
}

