/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public final class DateUtils {
    private static final DateTimeFormatter fullDayMonthFormatter = DateUtils.withoutYear(0);
    private static final DateTimeFormatter fullDayMonthYearFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL);
    private static final DateTimeFormatter dayFormatter = new DateTimeFormatterBuilder().appendPattern("EEEE").toFormatter(Locale.getDefault());
    private static final DateTimeFormatter shortDayFormatter = new DateTimeFormatterBuilder().appendPattern("EEE").toFormatter(Locale.getDefault());
    private static final DateTimeFormatter dayMonthFormatter = DateUtils.withoutYear(3);
    private static final DateTimeFormatter dayMonthYearFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private static final DateTimeFormatter timeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);

    private static DateTimeFormatter withoutYear(int format) {
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(format);
        String pattern = df.toLocalizedPattern().replaceAll(".?[Yy].?", "");
        return DateTimeFormatter.ofPattern(pattern);
    }

    private DateUtils() {
    }

    public static LocalDateTime of(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static String formatRelativeDateAndTime(LocalDateTime time) {
        StringBuilder date = new StringBuilder();
        date.append(DateUtils.formatRelativeDate(time));
        date.append(" ");
        date.append(DateUtils.formatTime(time));
        return date.toString();
    }

    public static String formatTime(LocalDateTime dateTime) {
        return dateTime.format(timeFormatter);
    }

    public static String formatRelativeDate(LocalDateTime dateTime) {
        LocalDateTime dayNow;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime day = dateTime.truncatedTo(ChronoUnit.DAYS);
        if (day.equals(dayNow = now.truncatedTo(ChronoUnit.DAYS))) {
            return ViewControllerHelper.getString("today");
        }
        if (day.equals(dayNow.minusDays(1L))) {
            return ViewControllerHelper.getString("yesterday");
        }
        if (day.isAfter(dayNow.minusDays(7L))) {
            return dateTime.format(dayFormatter);
        }
        if (day.getYear() == dayNow.getYear()) {
            return dateTime.format(fullDayMonthFormatter);
        }
        return dateTime.format(fullDayMonthYearFormatter);
    }

    public static String formatTimeOrDate(LocalDateTime dateTime) {
        LocalDateTime dayNow;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime day = dateTime.truncatedTo(ChronoUnit.DAYS);
        if (day.equals(dayNow = now.truncatedTo(ChronoUnit.DAYS))) {
            return DateUtils.formatTime(dateTime);
        }
        if (day.isAfter(dayNow.minusDays(7L))) {
            return dateTime.format(shortDayFormatter);
        }
        if (day.getYear() == dayNow.getYear()) {
            return dateTime.format(dayMonthFormatter);
        }
        return dateTime.format(dayMonthYearFormatter);
    }

    public static String formatDurationUnit(long durationInSeconds) {
        return DateUtils.formatDuration(durationInSeconds, true);
    }

    public static String formatDurationPlainText(long durationInSeconds) {
        return DateUtils.formatDuration(durationInSeconds, false);
    }

    private static String formatDuration(long durationInSeconds, boolean unit) {
        Duration duration = Duration.ofSeconds(durationInSeconds);
        long days = duration.toDays();
        if (days >= 365L) {
            long years = days / 365L;
            return TimeUnit.YEAR.getText(years, unit);
        }
        if (days > 0L) {
            return TimeUnit.DAY.getText(days, unit);
        }
        long hours = duration.toHours();
        if (hours > 0L) {
            return TimeUnit.HOUR.getText(hours, unit);
        }
        long minutes = duration.toMinutes();
        if (minutes > 0L) {
            return TimeUnit.MINUTE.getText(minutes, unit);
        }
        long seconds = duration.toSeconds();
        if (seconds > 0L) {
            return TimeUnit.SECOND.getText(seconds, unit);
        }
        return TimeUnit.INSTANT.getText(0, unit);
    }

    static enum TimeUnit {
        YEAR("year_unit", "year_text_singular", "year_text_plural"),
        DAY("day_unit", "day_text_singular", "day_text_plural"),
        HOUR("hour_unit", "hour_text_singular", "hour_text_plural"),
        MINUTE("minute_unit", "minute_text_singular", "minute_text_plural"),
        SECOND("second_unit", "second_text_singular", "second_text_plural"),
        INSTANT("instant_unit", "instant", "instant");

        private final MessageFormat unit;
        private final MessageFormat singular;
        private final MessageFormat plural;

        private TimeUnit(String formatUnit, String formatSingular, String formatPlural) {
            this.unit = new MessageFormat(ViewControllerHelper.getString(formatUnit));
            this.singular = new MessageFormat(ViewControllerHelper.getString(formatSingular));
            this.plural = new MessageFormat(ViewControllerHelper.getString(formatPlural));
        }

        public String getUnit(Number nb) {
            return this.unit.format(new String[]{nb.toString()});
        }

        public String getPlainText(Number nb) {
            MessageFormat format = nb.longValue() > 1L ? this.plural : this.singular;
            return format.format(new String[]{nb.toString()});
        }

        public String getText(Number nb, boolean unit) {
            return unit ? this.getUnit(nb) : this.getPlainText(nb);
        }
    }
}

