/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class Choice<L, M, R> {
    public static <L, M, R> Choice<L, M, R> left(L left) {
        return new Left(left);
    }

    public static <L, M, R> Choice<L, M, R> middle(M middle) {
        return new Middle(middle);
    }

    public static <L, M, R> Choice<L, M, R> right(R right) {
        return new Right(right);
    }

    public abstract Kind getKind();

    public abstract L getLeft();

    public abstract M getMiddle();

    public abstract R getRight();

    public final boolean isLeft() {
        return this.getKind() == Kind.LEFT;
    }

    public final boolean isMiddle() {
        return this.getKind() == Kind.MIDDLE;
    }

    public final boolean isRight() {
        return this.getKind() == Kind.RIGHT;
    }

    private static final class Left<L, M, R>
    extends Choice<L, M, R> {
        private final L left;

        Left(L left) {
            Objects.requireNonNull(left);
            this.left = left;
        }

        @Override
        public Kind getKind() {
            return Kind.LEFT;
        }

        @Override
        public L getLeft() {
            return this.left;
        }

        @Override
        public M getMiddle() {
            throw new NoSuchElementException("Try to call getMiddle on Left");
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("Try to call getRight on Left");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left1 = (Left)o;
            return Objects.equals(this.left, left1.left);
        }

        public int hashCode() {
            return Objects.hash(this.left);
        }

        public String toString() {
            return "left:" + String.valueOf(this.left);
        }
    }

    private static final class Middle<L, M, R>
    extends Choice<L, M, R> {
        private final M middle;

        Middle(M middle) {
            Objects.requireNonNull(middle);
            this.middle = middle;
        }

        @Override
        public Kind getKind() {
            return Kind.MIDDLE;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Try to call getLeft on Middle");
        }

        @Override
        public M getMiddle() {
            return this.middle;
        }

        @Override
        public R getRight() {
            throw new NoSuchElementException("Try to call getRight on Middle");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Middle left1 = (Middle)o;
            return Objects.equals(this.middle, left1.middle);
        }

        public int hashCode() {
            return Objects.hash(this.middle);
        }

        public String toString() {
            return "middle:" + String.valueOf(this.middle);
        }
    }

    private static final class Right<L, M, R>
    extends Choice<L, M, R> {
        private final R right;

        Right(R right) {
            Objects.requireNonNull(right);
            this.right = right;
        }

        @Override
        public Kind getKind() {
            return Kind.RIGHT;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("Try to call getLeft on Right");
        }

        @Override
        public M getMiddle() {
            throw new NoSuchElementException("Try to call getMiddle on Right");
        }

        @Override
        public R getRight() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right1 = (Right)o;
            return Objects.equals(this.right, right1.right);
        }

        public int hashCode() {
            return Objects.hash(this.right);
        }

        public String toString() {
            return "right:" + String.valueOf(this.right);
        }
    }

    public static enum Kind {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

