/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public abstract class AbstractTreeIterator<T>
implements Iterator<T> {
    private final T root;
    private boolean nextShouldIncludeRoot;
    final LinkedList<Iterator<T>> queue;

    public AbstractTreeIterator(T root) {
        this.root = root;
        this.nextShouldIncludeRoot = true;
        this.queue = new LinkedList();
        this.queue.push(this.getChildren(root));
    }

    protected abstract Iterator<T> getChildren(T var1);

    @Override
    public boolean hasNext() {
        if (this.nextShouldIncludeRoot) {
            return true;
        }
        return !this.queue.stream().filter(it -> it.hasNext()).findAny().isEmpty();
    }

    @Override
    public T next() {
        if (this.nextShouldIncludeRoot) {
            this.nextShouldIncludeRoot = false;
            return this.root;
        }
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        Iterator<T> iterator = this.queue.getFirst();
        if (iterator.hasNext()) {
            T next = iterator.next();
            this.queue.addFirst(this.getChildren(next));
            return next;
        }
        this.queue.removeFirst();
        return this.next();
    }
}

