/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.logger;

import io.olvid.engine.Logger;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class AppLogger
implements Logger.LogOutputter {
    private final Logger externalLogger;
    private static Logger externalStaticLogger;
    private static String LOG_CONFIG_FILE_NAME;
    private static final char[] hexArray;

    public static void reconfigureLog(String logConfigDirUri) {
        File file = new File(logConfigDirUri + LOG_CONFIG_FILE_NAME);
        if (file.exists()) {
            ((LoggerContext)LogManager.getContext((boolean)false)).setConfigLocation(file.toURI());
        } else {
            System.err.println("AppLogger::reconfigureLog Couldn't find log configuration file, only standard output available");
        }
    }

    public <T> AppLogger(Class<T> logOriginator) {
        this.externalLogger = LogManager.getLogger(logOriginator);
    }

    public static <T> void init(Class<T> logOriginator) {
        externalStaticLogger = LogManager.getLogger();
    }

    public void d(String s, String s1) {
        this.externalLogger.debug(s1);
    }

    public void i(String s, String s1) {
        this.externalLogger.info(s1);
    }

    public void w(String s, String s1) {
        this.externalLogger.warn(s1);
    }

    public void e(String s, String s1) {
        this.externalLogger.error(s1);
    }

    public void x(String tag, Throwable throwable) {
        this.externalLogger.warn((Object)throwable);
    }

    public void debug(String msg) {
        this.externalLogger.debug(msg);
    }

    public void debug(String msg, Object ... params) {
        externalStaticLogger.debug(String.format(msg, params));
    }

    public void info(String msg) {
        this.externalLogger.info(msg);
    }

    public void info(String msg, Object ... params) {
        this.externalLogger.info(String.format(msg, params));
    }

    public void warning(String msg) {
        this.externalLogger.warn(msg);
    }

    public void warning(String msg, Object ... params) {
        this.externalLogger.warn(String.format(msg, params));
    }

    public void error(String msg) {
        this.externalLogger.error(msg);
    }

    public void error(String msg, Exception e) {
        this.externalLogger.error(msg, (Throwable)e);
    }

    public void error(String msg, Object ... params) {
        this.externalLogger.error(String.format(msg, params));
    }

    public void trace(String msg, Object ... params) {
        this.externalLogger.trace(String.format(msg, params));
    }

    public void trace(String msg) {
        this.externalLogger.trace(msg);
    }

    public static void d(String msg) {
        externalStaticLogger.debug(msg);
    }

    public static void d(String msg, Object ... params) {
        externalStaticLogger.debug(String.format(msg, params));
    }

    public static void w(String msg) {
        externalStaticLogger.warn(msg);
    }

    public static void e(String msg) {
        externalStaticLogger.error(msg);
    }

    public static void e(String msg, Exception e) {
        externalStaticLogger.error(msg, (Throwable)e);
    }

    public static void i(String msg) {
        externalStaticLogger.info(msg);
    }

    public static void i(String msg, Object ... params) {
        externalStaticLogger.info(String.format(msg, params));
    }

    public static void t(String msg) {
        externalStaticLogger.trace(msg);
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        LOG_CONFIG_FILE_NAME = "olvid_log4j2_conf.properties";
        hexArray = "0123456789ABCDEF".toCharArray();
    }
}

