/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.gen.ContactRefGenerated;
import io.olvid.windows.messenger.database.tables.gen.PreContactGenerated;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.PreContactInfo;
import java.util.Optional;

public class PreContactInfoLiveData
extends MediatorLiveData<Optional<PreContactInfo>>
implements LiveDataListener<Optional<PreContact>> {
    private final Id<PreContact> id;
    private final MutableLiveData<Optional<Id<ContactRef>>> contactRefIdLiveData = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private final MutableLiveData<Optional<Id<IdentityDetails>>> identityDetailsIdLiveData = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private Optional<byte[]> bytesContactIdentity = Optional.empty();
    private Optional<IdentityDetailsInfo> identityDetailsInfo = Optional.empty();

    public PreContactInfoLiveData(Id<PreContact> id) {
        super(Optional.empty());
        this.id = id;
        this.addSource(id, DbManager.getInstance().getPreContactDao().getContextLiveData(), this);
        LiveData contactRefLiveData = DbManager.getInstance().getContactRefDao().getContextLiveData().of(Optional.empty(), this.contactRefIdLiveData);
        contactRefLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.bytesContactIdentity = newValue.map(ContactRefGenerated::getBytesContactIdentity);
            this.consolidate();
        });
        LiveData identityDetailLiveData = DbManager.getInstance().getIdentityDetailsDao().getContextLiveData().of(Optional.empty(), this.identityDetailsIdLiveData);
        identityDetailLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.identityDetailsInfo = newValue.map(IdentityDetailsInfo::new);
            this.consolidate();
        });
    }

    @Override
    public void onChange(Optional<PreContact> newValue, Optional<PreContact> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.contactRefIdLiveData.postValue(newValue.map(PreContactGenerated::getContactRefId));
        this.identityDetailsIdLiveData.postValue(newValue.map(PreContactGenerated::getIdentityDetailsId));
    }

    private void consolidate() {
        if (this.bytesContactIdentity.isEmpty() || this.identityDetailsInfo.isEmpty()) {
            this.postValue(Optional.empty());
            return;
        }
        this.postValue(Optional.of(new PreContactInfo(this.bytesContactIdentity.get(), this.identityDetailsInfo.get())));
    }

    public String toString() {
        return String.format("PreContactInfoMediatorLiveData[%s]", this.id);
    }

    public static MapLiveData<Id<PreContact>, Optional<PreContactInfo>> getMapLiveData() {
        return MapLiveData.of(PreContactInfoLiveData::new);
    }
}

