/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.gen.ContactRefGenerated;
import io.olvid.windows.messenger.database.tables.gen.PendingGroupMemberGenerated;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import java.util.Optional;

public class PendingGroupMemberInfoLiveData
extends MediatorLiveData<Optional<PendingGroupMemberInfo>>
implements LiveDataListener<Optional<PendingGroupMember>> {
    private final MutableLiveData<Optional<Id<ContactRef>>> contactRefIdLiveData = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private final MutableLiveData<Optional<Id<IdentityDetails>>> identityDetailsIdLiveData = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private Optional<byte[]> bytesContactIdentity = Optional.empty();
    private Optional<ContactInfo> contactInfo = Optional.empty();
    private Optional<IdentityDetailsInfo> identityDetailsInfo = Optional.empty();
    private Optional<PendingGroupMember> pendingGroupMember = Optional.empty();

    PendingGroupMemberInfoLiveData(Id<PendingGroupMember> id) {
        super(Optional.empty());
        this.addSource(id, DbManager.getInstance().getPendingGroupMemberDao().getContextLiveData(), this);
        LiveData contactRefLiveData = DbManager.getInstance().getContactRefDao().getContextLiveData().of(Optional.empty(), this.contactRefIdLiveData);
        contactRefLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.bytesContactIdentity = newValue.map(ContactRefGenerated::getBytesContactIdentity);
            this.consolidate();
        });
        LiveData<ContactInfoLiveData.ContactInfoState> contactInfoLiveData = DbCache.getInstance().contactRefInfoMapLiveData.of((ContactInfoLiveData.ContactInfoState)new ContactInfoLiveData.ContactInfoState.Computing(), this.contactRefIdLiveData);
        contactInfoLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.contactInfo = newValue.toOptional();
            this.consolidate();
        });
        LiveData identityDetailLiveData = DbManager.getInstance().getIdentityDetailsDao().getContextLiveData().of(Optional.empty(), this.identityDetailsIdLiveData);
        identityDetailLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.identityDetailsInfo = newValue.map(IdentityDetailsInfo::new);
            this.consolidate();
        });
    }

    @Override
    public void onChange(Optional<PendingGroupMember> newValue, Optional<PendingGroupMember> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.contactRefIdLiveData.postValue(newValue.map(PendingGroupMemberGenerated::getContactRefId));
        this.identityDetailsIdLiveData.postValue(newValue.map(PendingGroupMemberGenerated::getIdentityDetailsId));
        this.pendingGroupMember = newValue;
    }

    private void consolidate() {
        if (this.pendingGroupMember.isEmpty() || this.bytesContactIdentity.isEmpty() || this.identityDetailsInfo.isEmpty()) {
            this.postValue(Optional.empty());
            return;
        }
        this.postValue(Optional.of(new PendingGroupMemberInfo((Id<PendingGroupMember>)this.pendingGroupMember.get().getItemId(), this.bytesContactIdentity.get(), this.contactInfo, this.identityDetailsInfo.get(), this.pendingGroupMember.get().getSortDisplayName(), this.pendingGroupMember.get().isDeclined())));
    }

    public static MapLiveData<Id<PendingGroupMember>, Optional<PendingGroupMemberInfo>> getMapLiveData() {
        return MapLiveData.of(PendingGroupMemberInfoLiveData::new);
    }
}

