/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import java.util.Optional;

public class MessageRefLiveData
extends MediatorLiveData<Optional<MessageRefInfo>>
implements LiveDataListener<Optional<MessageRef>> {
    private final Id<MessageRef> messageRefId;
    private Optional<MessageRef> messageRef = Optional.empty();
    private final MutableLiveData<Optional<Id<InboundMessage>>> inboundMessageId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<InboundMessage> inboundMessage = Optional.empty();
    private final MutableLiveData<Optional<Id<OutboundMessage>>> outboundMessageId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<OutboundMessage> outboundMessage = Optional.empty();
    private final MutableLiveData<Optional<Id<OwnedMessage>>> ownedMessageId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<OwnedMessage> ownedMessage = Optional.empty();

    public MessageRefLiveData(Id<MessageRef> messageRefId) {
        super(Optional.empty());
        this.messageRefId = messageRefId;
        this.addSource(messageRefId, DbManager.getInstance().getMessageRefDao().getContextLiveData(), this);
        LiveData inboundMessageLiveData = DbManager.getInstance().getInboundMessageDao().getContextLiveData().of(Optional.empty(), this.inboundMessageId);
        inboundMessageLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.inboundMessage = newValue;
            this.consolidate();
        });
        LiveData outboundMessageLiveData = DbManager.getInstance().getOutboundMessageDao().getContextLiveData().of(Optional.empty(), this.outboundMessageId);
        outboundMessageLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.outboundMessage = newValue;
            this.consolidate();
        });
        LiveData ownedMessageLiveData = DbManager.getInstance().getOwnedMessageDao().getContextLiveData().of(Optional.empty(), this.ownedMessageId);
        ownedMessageLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.ownedMessage = newValue;
            this.consolidate();
        });
    }

    protected void consolidate() {
        if (this.messageRef.isEmpty()) {
            this.postValue(Optional.empty());
            return;
        }
        MessageRef messageRef = this.messageRef.get();
        if (messageRef.getInboundMessageId().isPresent() && this.inboundMessage.isEmpty()) {
            return;
        }
        if (messageRef.getOutboundMessageId().isPresent() && this.outboundMessage.isEmpty()) {
            return;
        }
        if (messageRef.getOwnedMessageId().isPresent() && this.ownedMessage.isEmpty()) {
            return;
        }
        this.postValue(Optional.of(new MessageRefInfo((Id<MessageRef>)messageRef.getItemId(), messageRef.isMessageHasBeenReceived(), this.inboundMessage, this.outboundMessage, this.ownedMessage)));
    }

    public static MapLiveData<Id<MessageRef>, Optional<MessageRefInfo>> getMapLiveData() {
        return MapLiveData.of(MessageRefLiveData::new);
    }

    public String toString() {
        return String.format("MessageRefLiveData[%s]", this.messageRefId);
    }

    @Override
    public void onChange(Optional<MessageRef> newValue, Optional<MessageRef> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.messageRef = newValue;
        if (newValue.isEmpty()) {
            this.postValue(Optional.empty());
            return;
        }
        MessageRef messageRef = newValue.get();
        this.inboundMessageId.postValue(messageRef.getInboundMessageId());
        this.outboundMessageId.postValue(messageRef.getOutboundMessageId());
        this.ownedMessageId.postValue(messageRef.getOwnedMessageId());
        this.consolidate();
    }
}

