/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.dao.message.AbstractMessageDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageKind;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.MessageItem;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.mediator.MessageIdsLiveData;
import io.olvid.windows.messenger.misc.Watches;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class MessageItemLiveData
extends MediatorLiveData<List<MessageItem>> {
    private static final int PAGE_SIZE = 100;
    private static final int MESSAGES_ABOVE_FIRST_UNREAD = 10;
    private final Id<Discussion> discussionId;
    private List<MessageItem> messages = List.of();
    private Optional<Id<InboundMessage>> firstUnreadMessage = Optional.empty();
    private List<SortableItemId> messagesIds = List.of();

    public MessageItemLiveData(Discussion discussion, LiveData<Double> scrollPositionLiveData, LiveData<Optional<DiscussionViewModel.SearchedItem>> currentSearchedItemLiveData) {
        super(List.of());
        this.discussionId = discussion.getItemId();
        this.addSource(new MessageIdsLiveData(discussion), (newValue, oldValue) -> {
            this.messagesIds = newValue.itemIds();
            this.firstUnreadMessage = newValue.firstUnreadMessageId();
            this.consolidate(newValue.updateMode());
        });
        this.addSource(currentSearchedItemLiveData, (newValue, oldValue) -> {
            if (newValue.isEmpty()) {
                return;
            }
            DiscussionViewModel.SearchedItem currentSearchedItem = (DiscussionViewModel.SearchedItem)newValue.get();
            int newCurrentIdx = this.messagesIds.indexOf(currentSearchedItem.id());
            if (newCurrentIdx == -1) {
                return;
            }
            int indexInMessages = this.messagesIds.size() - 1 - newCurrentIdx;
            if (indexInMessages >= this.messages.size()) {
                int lastMissingMessagesIdx = indexInMessages - this.messages.size() + 1;
                for (int pagesToLoad = (lastMissingMessagesIdx - 1) / 100 + 1; pagesToLoad > 0; --pagesToLoad) {
                    this.addPage();
                }
            }
        });
        this.addSource(scrollPositionLiveData, (newValue, oldValue) -> {
            if (newValue != null && newValue == 0.0) {
                this.addPage();
            }
        });
    }

    private synchronized void addPage() {
        ViewControllerHelper.checkNotUIThread();
        if (this.messages.size() == this.messagesIds.size()) {
            return;
        }
        List<SortableItemId> nextPageId = this.getNextPageIds();
        if (nextPageId.isEmpty()) {
            return;
        }
        List<MessageItem> nextPage = this.getAll(nextPageId, MessageIdsLiveData.UpdateMode.ALL);
        this.linkMessageItems(nextPage);
        this.messages = new ArrayList<MessageItem>(this.messages);
        MessageItem currentFirstItemCopy = this.messages.get(0).clone();
        currentFirstItemCopy.setShowSpinner(false);
        currentFirstItemCopy.setPrevious(nextPage.get(nextPage.size() - 1));
        this.messages.set(0, currentFirstItemCopy);
        MessageItem lastOfNewPageItem = nextPage.get(nextPage.size() - 1);
        lastOfNewPageItem.setNext(currentFirstItemCopy);
        this.messages.addAll(0, nextPage);
        this.configureHead();
        this.postValue(this.messages);
    }

    private List<SortableItemId> getNextPageIds() {
        int last = this.messagesIds.size() - this.messages.size();
        if (last == 0) {
            return List.of();
        }
        int first = Math.max(0, last - 100);
        return this.messagesIds.subList(first, last);
    }

    private void linkMessageItems(List<MessageItem> items) {
        MessageItem previous = null;
        for (MessageItem item : items) {
            if (previous != null) {
                item.setPrevious(previous);
                previous.setNext(item);
            }
            previous = item;
        }
    }

    private void configureHead() {
        if (this.messages.size() < 2) {
            return;
        }
        boolean showSpinner = this.messages.size() < this.messagesIds.size();
        MessageItem messageItem = this.messages.get(0);
        messageItem.setShowSpinner(showSpinner);
    }

    private Optional<UnreadInfo> getUnreadInfo() {
        if (this.firstUnreadMessage.isEmpty()) {
            return Optional.empty();
        }
        int unreadCount = 0;
        for (int i = this.messagesIds.size() - 1; 0 <= i; --i) {
            SortableItemId itemId = this.messagesIds.get(i);
            if (itemId.getKind() != MessageKind.INBOUND) continue;
            ++unreadCount;
            if (!((Id)itemId.itemId().inbound).equals(this.firstUnreadMessage.get())) continue;
            return Optional.of(new UnreadInfo(i, unreadCount));
        }
        this.loggerInstance.error("Unread message not found");
        return Optional.empty();
    }

    private synchronized void consolidate(MessageIdsLiveData.UpdateMode updateMode) {
        ViewControllerHelper.checkNotUIThread();
        if (this.messagesIds.isEmpty()) {
            return;
        }
        int firstPageIndex = -1;
        if (this.messages == null || this.messages.isEmpty()) {
            firstPageIndex = Math.max(0, this.messagesIds.size() - 100);
        } else {
            SortableItemId first = this.messages.get(0).getItemId();
            for (int i = 0; i < this.messagesIds.size(); ++i) {
                if (!this.messagesIds.get(i).equals(first)) continue;
                firstPageIndex = i;
                break;
            }
            if (firstPageIndex == -1) {
                firstPageIndex = this.messagesIds.size() - this.messages.size();
            }
        }
        Optional<UnreadInfo> unreadInfo = this.getUnreadInfo();
        if (unreadInfo.isPresent()) {
            int firstUnreadIndex = Math.max(0, unreadInfo.get().index - 10);
            firstPageIndex = Math.min(firstUnreadIndex, firstPageIndex);
        }
        List<SortableItemId> ids = this.messagesIds.subList(firstPageIndex, this.messagesIds.size());
        this.messages = this.getAll(ids, updateMode);
        if (unreadInfo.isPresent()) {
            MessageItem firstUnread = this.messages.get(unreadInfo.get().index - firstPageIndex);
            firstUnread.setUnreadCount(unreadInfo.get().count);
        }
        this.configureHead();
        this.linkMessageItems(this.messages);
        this.postValue(this.messages);
    }

    private <Message extends AbstractMessageGenerated<Message>, Interface> void computeAll(SortIndexInfo range, Map<SortableItemId, MessageItem> itemsMap, MessageKind kind, boolean compute, AbstractMessageDao<Message, Interface> dao, Function<Interface, MessageItem> messageItemFactory, List<MessageItem> currentItems) {
        if (compute) {
            double minSortIndex = range.min();
            double maxSortIndex = range.max();
            Watches.Watch start = Watches.getInstance().start("MessageItemLiveData#getAll " + String.valueOf((Object)kind));
            List<Interface> messages = dao.getAll(this.discussionId, minSortIndex, maxSortIndex);
            start.stop();
            for (Interface message : messages) {
                MessageItem item = messageItemFactory.apply(message);
                itemsMap.put(item.getItemId(), item);
            }
        } else {
            for (MessageItem item : currentItems) {
                if (item.getItemId().getKind() != kind) continue;
                itemsMap.put(item.getItemId(), item);
            }
        }
    }

    private List<MessageItem> getAll(List<SortableItemId> itemIds, MessageIdsLiveData.UpdateMode updateMode) {
        HashMap<SortableItemId, MessageItem> itemsMap = new HashMap<SortableItemId, MessageItem>();
        Optional<SortIndexInfo> sortIndexInfoOpt = SortIndexInfo.of(this.discussionId, itemIds);
        if (sortIndexInfoOpt.isEmpty()) {
            return List.of();
        }
        SortIndexInfo sortIndexInfo = sortIndexInfoOpt.get();
        this.computeAll(sortIndexInfo, itemsMap, MessageKind.INBOUND, updateMode.computeInbound(), DbManager.getInstance().getInboundMessageDao(), MessageItem::of, this.messages);
        this.computeAll(sortIndexInfo, itemsMap, MessageKind.OUTBOUND, updateMode.computeOutbound(), DbManager.getInstance().getOutboundMessageDao(), MessageItem::of, this.messages);
        this.computeAll(sortIndexInfo, itemsMap, MessageKind.OWNED, updateMode.computeOwned(), DbManager.getInstance().getOwnedMessageDao(), MessageItem::of, this.messages);
        this.computeAll(sortIndexInfo, itemsMap, MessageKind.SYSTEM, updateMode.computeSystem(), DbManager.getInstance().getSystemMessageDao(), MessageItem::of, this.messages);
        ArrayList<MessageItem> result = new ArrayList<MessageItem>();
        for (SortableItemId itemId : itemIds) {
            if (itemId.getKind() == MessageKind.DISCLAIMER) {
                result.add(MessageItem.disclaimer(this.discussionId));
                continue;
            }
            MessageItem messageItem = (MessageItem)itemsMap.get(itemId);
            if (messageItem == null) {
                this.loggerInstance.error("Missing message");
                continue;
            }
            result.add(messageItem);
        }
        return result;
    }

    record UnreadInfo(int index, int count) {
    }

    public record SortIndexInfo(Id<Discussion> discussionId, double min, double max) {
        static Optional<SortIndexInfo> of(Id<Discussion> discussionId, List<SortableItemId> itemIds) {
            if (itemIds == null || itemIds.isEmpty()) {
                return Optional.empty();
            }
            SortableItemId first = itemIds.get(0);
            List<SortableItemId> ids = first.getSortIndex() == 0.0 && itemIds.size() > 100 ? itemIds.subList(1, itemIds.size()) : itemIds;
            if (ids.isEmpty()) {
                return Optional.empty();
            }
            double min = ids.get(0).getSortIndex();
            double max = ids.get(ids.size() - 1).getSortIndex();
            return Optional.of(new SortIndexInfo(discussionId, min, max));
        }

        public static Optional<SortIndexInfo> of(List<MessageItem> messages) {
            if (messages == null || messages.isEmpty()) {
                return Optional.empty();
            }
            MessageItem first = messages.get(0);
            List<MessageItem> messageItems = first.getItemId().getKind() == MessageKind.DISCLAIMER ? messages.subList(1, messages.size()) : messages;
            if (messageItems.isEmpty()) {
                return Optional.empty();
            }
            double min = messageItems.get(0).getSortIndex();
            double max = messageItems.get(messageItems.size() - 1).getSortIndex();
            return Optional.of(new SortIndexInfo(first.getDiscussionId(), min, max));
        }
    }
}

