/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.Optional;

public final class IdentityInfoLiveData
extends MediatorLiveData<Optional<IdentityInfo>>
implements LiveDataListener<Optional<IdentityRef>> {
    private final Id<IdentityRef> refId;
    private Boolean isMe;
    private Optional<ContactInfo> contactInfo = Optional.empty();
    private Optional<OwnedIdentityInfo> ownedIdentityInfo = Optional.empty();

    public IdentityInfoLiveData(Id<IdentityRef> refId) {
        super(Optional.empty());
        this.refId = refId;
        LiveData identityRefLiveData = DbManager.getInstance().getIdentityRefDao().getContextLiveData().of(Optional.empty(), refId);
        this.addSource(identityRefLiveData, this);
    }

    @Override
    public void onChange(Optional<IdentityRef> newValue, Optional<IdentityRef> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        if (newValue.isEmpty() && this.isMe != null) {
            this.clearSources();
        }
        if (this.isMe != null) {
            return;
        }
        IdentityRef identityRef = DbManager.getInstance().getIdentityRefDao().get(this.refId);
        this.isMe = identityRef.getOwnedIdentityId().isPresent();
        if (this.isMe.booleanValue()) {
            this.addSource(identityRef.getOwnedIdentityId().get(), DbCache.getInstance().ownedIdentityMapLiveData, (newValue1, oldValue1) -> {
                this.ownedIdentityInfo = newValue1;
                this.consolidate();
            });
        } else if (identityRef.getContactRefId().isPresent()) {
            this.addSource(identityRef.getContactRefId().get(), DbCache.getInstance().contactRefInfoMapLiveData, (newValue1, oldValue1) -> {
                this.contactInfo = newValue1.toOptional();
                this.consolidate();
            });
        }
    }

    private void consolidate() {
        if (this.isMe.booleanValue()) {
            if (this.ownedIdentityInfo.isEmpty()) {
                this.postValue(Optional.empty());
            } else {
                this.postValue(Optional.of(IdentityInfo.makeOwnedInfo(this.refId, this.ownedIdentityInfo.get())));
            }
        } else {
            this.postValue(Optional.of(IdentityInfo.makeContactInfo(this.refId, this.contactInfo)));
        }
    }

    public static MapLiveData<Id<IdentityRef>, Optional<IdentityInfo>> getMapLiveData() {
        return MapLiveData.of(IdentityInfoLiveData::new);
    }
}

