/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.mediator.MessageIdsLiveData;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.Watches;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DiscussionSearchResultLiveData
extends MediatorLiveData<SearchResultInfo> {
    private List<DiscussionViewModel.SearchedItem> searchedItemList = new ArrayList<DiscussionViewModel.SearchedItem>();
    private List<SortableItemId> messageIds = List.of();
    private Optional<String> searchText;
    private Optional<Id<Discussion>> selectedDiscussion = Optional.empty();

    public DiscussionSearchResultLiveData(LiveData<Optional<String>> searchLD) {
        super(SearchResultInfo.of(List.of(), ChangeOrigin.NONE));
        this.addSource(LiveDataFactory.switchMap(DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData(), discussion -> {
            this.selectedDiscussion = discussion == null ? Optional.empty() : Optional.of(discussion.getItemId());
            return discussion == null ? null : new MessageIdsLiveData((Discussion)discussion);
        }), (newValue, oldValue) -> {
            this.messageIds = newValue == null ? List.of() : newValue.itemIds();
            this.consolidate(ChangeOrigin.MESSAGE_LIST_UPDATE);
        });
        this.addSource(searchLD, (newValue, oldValue) -> {
            this.searchText = newValue;
            this.consolidate(ChangeOrigin.SEARCH_TEXT_INPUT);
        });
    }

    private synchronized void consolidate(ChangeOrigin changeOrigin) {
        int i;
        if (this.searchText.isEmpty() || this.searchText.get().isEmpty() || this.messageIds.isEmpty() || this.selectedDiscussion.isEmpty()) {
            this.searchedItemList.clear();
            this.postValue(SearchResultInfo.of(List.of(), changeOrigin));
            return;
        }
        if (changeOrigin.equals((Object)ChangeOrigin.DISCUSSION_CHANGED)) {
            this.searchedItemList.clear();
            this.postValue(SearchResultInfo.of(List.of(), changeOrigin));
            return;
        }
        String[] words = this.searchText.get().trim().split("[\\p{Punct}\\s]+");
        ArrayList<String> stringSimplePattern = new ArrayList<String>();
        for (String word : words) {
            if (word.trim().isEmpty()) continue;
            stringSimplePattern.add(word);
        }
        if (stringSimplePattern.isEmpty()) {
            this.searchedItemList.clear();
            this.postValue(SearchResultInfo.of(List.of(), changeOrigin));
            return;
        }
        Watches.Watch ftsQueryWatchInbound = Watches.getInstance().start("ftsQueryWatch[inbound]");
        List<SortableItemId> withSortIndexListInbound = DbManager.getInstance().getInboundMessageDao().ftsInDiscussion(this.selectedDiscussion.get(), stringSimplePattern);
        ftsQueryWatchInbound.stop();
        Watches.Watch ftsQueryWatchOutbound = Watches.getInstance().start("ftsQueryWatch[outbound]");
        List<SortableItemId> withSortIndexListOutbound = DbManager.getInstance().getOutboundMessageDao().ftsInDiscussion(this.selectedDiscussion.get(), stringSimplePattern);
        ftsQueryWatchOutbound.stop();
        Watches.Watch ftsQueryWatchOwned = Watches.getInstance().start("ftsQueryWatch[owned]");
        List<SortableItemId> withSortIndexListOwned = DbManager.getInstance().getOwnedMessageDao().ftsInDiscussion(this.selectedDiscussion.get(), stringSimplePattern);
        ftsQueryWatchOwned.stop();
        Watches.Watch sortMergeWatch = Watches.getInstance().start("sortMergeSearchResultWatch");
        List mergedCollection = CollectionUtils.kWayMerge(withSortIndexListInbound, withSortIndexListOutbound, withSortIndexListOwned);
        sortMergeWatch.stop();
        ArrayList<DiscussionViewModel.SearchedItem> searchedItems = new ArrayList<DiscussionViewModel.SearchedItem>();
        ArrayList<Pair<SortableItemId, Integer>> ids = new ArrayList<Pair<SortableItemId, Integer>>();
        for (i = 0; i < this.messageIds.size(); ++i) {
            SortableItemId message = this.messageIds.get(i);
            if (!mergedCollection.contains(message)) continue;
            ids.add(Pair.of(message, i));
        }
        for (i = 0; i < ids.size(); ++i) {
            Pair pair = (Pair)ids.get(i);
            searchedItems.add(new DiscussionViewModel.SearchedItem((SortableItemId)pair.getFirst(), i, (Integer)pair.getSecond(), i == 0, i == ids.size() - 1));
        }
        Watches.Watch compareOldAndNewWatch = Watches.getInstance().start("DiscussionSearchResult::compareOldAndNewWatch");
        if (!changeOrigin.equals((Object)ChangeOrigin.SEARCH_TEXT_INPUT) && this.searchedItemList.equals(searchedItems)) {
            return;
        }
        compareOldAndNewWatch.stop();
        this.searchedItemList = searchedItems;
        this.postValue(SearchResultInfo.of(this.searchedItemList, changeOrigin));
    }

    public List<DiscussionViewModel.SearchedItem> getSearchedItems() {
        return this.searchedItemList;
    }

    public static enum ChangeOrigin {
        SEARCH_TEXT_INPUT,
        MESSAGE_LIST_UPDATE,
        DISCUSSION_CHANGED,
        NONE;

    }

    public record SearchResultInfo(List<DiscussionViewModel.SearchedItem> searchedItems, ChangeOrigin origin) {
        public static SearchResultInfo of(List<DiscussionViewModel.SearchedItem> searchedItems, ChangeOrigin origin) {
            return new SearchResultInfo(searchedItems, origin);
        }
    }
}

