/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import java.util.Optional;
import java.util.Set;

public class DiscussionInfoWithStateLiveData
extends MediatorLiveData<DiscussionInfoWithState>
implements LiveDataListener<Optional<Discussion>> {
    protected final Id<Discussion> id;
    protected Optional<DiscussionInfo> discussionInfo = Optional.empty();
    protected boolean canPostMessage = false;
    protected boolean channelCreation = false;
    protected boolean canEditOwnedMessage = false;
    private final MutableLiveData<Optional<Id<Contact>>> contactId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private final MutableLiveData<Optional<Id<Group>>> groupId = LiveDataFactory.buildMutableLiveData(Optional.empty());

    public DiscussionInfoWithStateLiveData(Id<Discussion> id) {
        super(new DiscussionInfoWithState(DiscussionInfo.empty(id), false, false, false));
        this.id = id;
        this.addSource(id, DbManager.getInstance().getDiscussionDao().getContextLiveData(), this);
        this.addSource(id, DbCache.getInstance().discussionInfoMapLiveData, (newValue, oldValue) -> {
            this.discussionInfo = Optional.of(newValue);
            this.consolidate();
        });
        LiveData contactInfoLiveData = DbCache.getInstance().contactInfoMapLiveData.of(Optional.empty(), this.contactId);
        contactInfoLiveData.addListener((DataType newValue, DataType oldValue) -> {
            if (newValue.isEmpty()) {
                return;
            }
            ContactInfo contactInfo = (ContactInfo)newValue.get();
            this.canPostMessage = true;
            this.channelCreation = !contactInfo.isReachable();
            this.canEditOwnedMessage = true;
            this.consolidate();
        });
        LiveData ownGroupPermissionLiveData = LiveDataFactory.switchMap(this.groupId, groupIdOpt -> {
            if (groupIdOpt.isEmpty()) {
                return null;
            }
            return LiveDataFactory.buildDbLiveDataItem(GroupMemberPermissions.class, () -> DbManager.getInstance().getGroupMemberPermissionsDao().getOwnPermission((Id)groupIdOpt.get()));
        });
        ownGroupPermissionLiveData.addListener((DataType newValue, DataType oldValue) -> {
            if (newValue == null) {
                return;
            }
            Set<GroupV2.Permission> permissions = newValue.getPermissions();
            this.canPostMessage = permissions.contains(GroupV2.Permission.SEND_MESSAGE);
            this.channelCreation = false;
            this.canEditOwnedMessage = permissions.contains(GroupV2.Permission.EDIT_OR_REMOTE_DELETE_OWN_MESSAGES);
            this.consolidate();
        });
    }

    @Override
    public void onChange(Optional<Discussion> newValue, Optional<Discussion> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.contactId.postValue(newValue.flatMap(DiscussionGenerated::getContactId));
        this.groupId.postValue(newValue.flatMap(DiscussionGenerated::getGroupId));
    }

    protected void consolidate() {
        if (this.discussionInfo.isEmpty()) {
            return;
        }
        this.postValue(new DiscussionInfoWithState(this.discussionInfo.get(), this.canPostMessage, this.channelCreation, this.canEditOwnedMessage));
    }

    public static MapLiveData<Id<Discussion>, DiscussionInfoWithState> getMapLiveData() {
        return MapLiveData.of(DiscussionInfoWithStateLiveData::new);
    }
}

