/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.PreGroup;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.livedata.info.GroupInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.PreContactInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class DiscussionInfoLiveData
extends MediatorLiveData<DiscussionInfo>
implements LiveDataListener<Optional<Discussion>> {
    protected final AppLogger logger = new AppLogger(this.getClass());
    protected final Id<Discussion> id;
    protected Optional<Discussion> discussion = Optional.empty();
    private final MutableLiveData<Optional<Id<Contact>>> contactId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<ContactInfo> contactInfo = Optional.empty();
    private final MutableLiveData<Optional<Id<PreContact>>> preContactId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<PreContactInfo> preContactInfo = Optional.empty();
    private final MutableLiveData<Optional<Id<Group>>> groupId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<GroupInfo> groupInfo = Optional.empty();
    private final MutableLiveData<Optional<Id<PreGroup>>> preGroupId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    protected Optional<PreGroup> preGroupInfo = Optional.empty();

    public DiscussionInfoLiveData(Id<Discussion> id, MapLiveData<Id<PreContact>, Optional<PreContactInfo>> preContactInfoLiveData, MapLiveData<Id<Group>, Optional<GroupInfo>> groupInfoLiveData) {
        super(DiscussionInfo.empty(id));
        this.id = id;
        this.addSource(id, DbManager.getInstance().getDiscussionDao().getContextLiveData(), this);
        LiveData contactInfoLiveData = DbCache.getInstance().contactInfoMapLiveData.of(Optional.empty(), this.contactId);
        contactInfoLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.contactInfo = newValue;
            if (newValue.isPresent()) {
                this.preContactInfo = Optional.empty();
                this.groupInfo = Optional.empty();
                this.preGroupInfo = Optional.empty();
            }
            this.consolidate();
        });
        LiveData preContactLiveData = preContactInfoLiveData.of(Optional.empty(), this.preContactId);
        preContactLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.preContactInfo = newValue;
            if (newValue.isPresent()) {
                this.contactInfo = Optional.empty();
                this.groupInfo = Optional.empty();
                this.preGroupInfo = Optional.empty();
            }
            this.consolidate();
        });
        LiveData groupLiveData = groupInfoLiveData.of(Optional.empty(), this.groupId);
        groupLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.groupInfo = newValue;
            if (newValue.isPresent()) {
                this.contactInfo = Optional.empty();
                this.preContactInfo = Optional.empty();
                this.preGroupInfo = Optional.empty();
            }
            this.consolidate();
        });
        LiveData preGroupLiveData = DbManager.getInstance().getPreGroupDao().getContextLiveData().of(Optional.empty(), this.preGroupId);
        preGroupLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.preGroupInfo = newValue;
            if (newValue.isPresent()) {
                this.contactInfo = Optional.empty();
                this.preContactInfo = Optional.empty();
                this.groupInfo = Optional.empty();
            }
            this.consolidate();
        });
    }

    @Override
    public void onChange(Optional<Discussion> newValue, Optional<Discussion> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.discussion = newValue;
        this.consolidate();
        this.contactId.postValue(newValue.flatMap(DiscussionGenerated::getContactId));
        this.preContactId.postValue(newValue.flatMap(DiscussionGenerated::getPreContactId));
        this.groupId.postValue(newValue.flatMap(DiscussionGenerated::getGroupId));
        this.preGroupId.postValue(newValue.flatMap(DiscussionGenerated::getPreGroupId));
    }

    protected void consolidate() {
        DiscussionInfo discussionInfo;
        if (this.discussion.isEmpty()) {
            return;
        }
        if (this.contactInfo.isPresent()) {
            ContactInfo info = this.contactInfo.get();
            discussionInfo = new DiscussionInfo((Id<Discussion>)this.discussion.get().getItemId(), Optional.of(info.getCustomOrDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)), Optional.ofNullable(info.getCustomOrDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY)), this.discussion.get().getSortTimestamp(), info.bytesContactIdentity(), info.isKeycloakManaged(), info.getCustomPhotoUrlOrPhotoUrl(), this.discussion.get().getKind());
        } else if (this.preContactInfo.isPresent()) {
            PreContactInfo info = this.preContactInfo.get();
            discussionInfo = new DiscussionInfo((Id<Discussion>)this.discussion.get().getItemId(), Optional.of(info.details().getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)), Optional.ofNullable(info.details().getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY)), this.discussion.get().getSortTimestamp(), info.bytesForInitialView(), false, info.details().photoUrl(), this.discussion.get().getKind());
        } else if (this.groupInfo.isPresent()) {
            GroupInfo info = this.groupInfo.get();
            discussionInfo = new DiscussionInfo((Id<Discussion>)this.discussion.get().getItemId(), Optional.of(info.getTitle()), Optional.of(info.getSubTitle()), this.discussion.get().getSortTimestamp(), info.getBytesGroupIdentifier(), info.keycloakManaged(), info.photoURL(), this.discussion.get().getKind());
        } else if (this.preGroupInfo.isPresent()) {
            PreGroup info = this.preGroupInfo.get();
            discussionInfo = new DiscussionInfo((Id<Discussion>)this.discussion.get().getItemId(), info.getName().or(info::getPreGroupMembersNames), info.getName().isPresent() ? info.getPreGroupMembersNames() : Optional.empty(), this.discussion.get().getSortTimestamp(), info.getBytesGroupIdentifier(), false, Optional.empty(), this.discussion.get().getKind());
        } else if (this.discussion.get().isLocked()) {
            Optional<String> title = this.discussion.get().getLockedTitle().flatMap(OptionalUtils::noneIfEmpty).or(() -> Optional.of(ViewControllerHelper.getString("unnamed_group")));
            discussionInfo = new DiscussionInfo((Id<Discussion>)this.discussion.get().getItemId(), title, Optional.empty(), this.discussion.get().getSortTimestamp(), this.discussion.get().getLockedTitle().map(s -> s.getBytes(StandardCharsets.UTF_8)).orElse(new byte[0]), false, Optional.empty(), this.discussion.get().getKind());
        } else {
            return;
        }
        this.postValue(discussionInfo);
    }

    public static MapLiveData<Id<Discussion>, DiscussionInfo> getMapLiveData(MapLiveData<Id<PreContact>, Optional<PreContactInfo>> preContactInfoLiveData, MapLiveData<Id<Group>, Optional<GroupInfo>> groupInfoLiveData) {
        return MapLiveData.of(id -> new DiscussionInfoLiveData((Id<Discussion>)id, preContactInfoLiveData, groupInfoLiveData));
    }

    public String toString() {
        return String.format("DiscussionInfoLiveData[%s]", this.id);
    }
}

