/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.DiscussionCustomization;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.gen.DiscussionGenerated;
import io.olvid.windows.messenger.database.tables.gen.LocationGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.engine.helpers.message.MessageHelper;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.cache.UnreadMessageCountCache;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoForCell;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import java.util.Optional;

public class DiscussionInfoForCellLiveData
extends MediatorLiveData<Optional<DiscussionInfoForCell>>
implements LiveDataListener<Optional<Discussion>> {
    private final Id<Discussion> id;
    protected Optional<DiscussionInfo> discussionInfo = Optional.empty();
    private final MutableLiveData<Optional<Id<MessageRef>>> lastUserMessageRefId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private final MutableLiveData<Optional<Id<SystemMessage>>> lastSystemMessageId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private Optional<MessageRefInfo> messageRefInfo = Optional.empty();
    private Optional<String> lastSystemMessageBody = Optional.empty();
    private final MutableLiveData<Optional<Id<Location>>> locationId = LiveDataFactory.buildMutableLiveData(Optional.empty());
    private Optional<Location> location = Optional.empty();
    private Optional<Long> lastTimestamp = Optional.empty();
    private long unreadMessageCount = 0L;
    private Optional<Long> muteNotificationsTimestamp = Optional.empty();

    public DiscussionInfoForCellLiveData(Id<Discussion> id, MapLiveData<Id<MessageRef>, Optional<MessageRefInfo>> messageRefInfoMapLiveData) {
        super(Optional.empty());
        this.id = id;
        this.addSource(id, DbManager.getInstance().getDiscussionDao().getContextLiveData(), this);
        this.addSource(id, DbCache.getInstance().discussionInfoMapLiveData, (newValue, oldValue) -> {
            this.discussionInfo = Optional.of(newValue);
            this.consolidate();
        });
        LiveData<UnreadMessageCountCache.Info> unreadCountLiveData = UnreadMessageCountCache.getInstance().getUnreadCountLiveData();
        this.addSource(unreadCountLiveData, (newValue, oldValue) -> {
            this.unreadMessageCount = newValue.getUnreadMessageCount(id);
            this.consolidate();
        });
        this.addSource(LiveDataFactory.buildDbLiveDataItem(DiscussionCustomization.class, () -> DbManager.getInstance().getDiscussionCustomizationDao().getDiscussionCustomization(id)), (newValue, oldValue) -> {
            this.muteNotificationsTimestamp = newValue.getPrefMuteNotificationsTimestamp();
            this.consolidate();
        });
        LiveData messageRefInfoLiveData = messageRefInfoMapLiveData.of(Optional.empty(), this.lastUserMessageRefId);
        messageRefInfoLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.messageRefInfo = newValue;
            this.locationId.postValue(newValue.flatMap(MessageRefInfo::getLocationId));
            if (newValue.isPresent()) {
                this.lastSystemMessageBody = Optional.empty();
                this.lastTimestamp = ((MessageRefInfo)newValue.get()).getTimestamp();
            }
            this.consolidate();
        });
        LiveData locationLiveData = DbManager.getInstance().getLocationDao().getContextLiveData().of(Optional.empty(), this.locationId);
        locationLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.location = newValue;
            this.lastTimestamp = newValue.map(LocationGenerated::getTimestamp);
            this.consolidate();
        });
        LiveData systemMessageLiveData = DbManager.getInstance().getSystemMessageDao().getContextLiveData().of(Optional.empty(), this.lastSystemMessageId);
        systemMessageLiveData.addListener((DataType newValue, DataType oldValue) -> {
            this.lastSystemMessageBody = newValue.map(SystemMessage::getStringContent);
            if (newValue.isPresent()) {
                this.messageRefInfo = Optional.empty();
                this.lastTimestamp = newValue.map(AbstractMessageGenerated::getTimestamp);
            }
            this.consolidate();
        });
    }

    @Override
    public void onChange(Optional<Discussion> newValue, Optional<Discussion> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.lastUserMessageRefId.postValue(newValue.flatMap(DiscussionGenerated::getLastUserMessageRefId));
        this.lastSystemMessageId.postValue(newValue.flatMap(DiscussionGenerated::getLastSystemMessageId));
    }

    private void consolidate() {
        if (this.discussionInfo.isEmpty()) {
            return;
        }
        Optional<String> lastMessageBody = this.messageRefInfo.isPresent() ? (this.location.isPresent() ? Optional.of(MessageHelper.getLocationContent(this.location.get().getType())) : this.messageRefInfo.get().getBody()) : this.lastSystemMessageBody;
        DiscussionInfoForCell discussionInfoForCell = new DiscussionInfoForCell(this.discussionInfo.get(), lastMessageBody, this.lastTimestamp.orElse(-1L), this.unreadMessageCount, this.muteNotificationsTimestamp);
        this.postValue(Optional.of(discussionInfoForCell));
    }

    public static MapLiveData<Id<Discussion>, Optional<DiscussionInfoForCell>> getMapLiveData(MapLiveData<Id<MessageRef>, Optional<MessageRefInfo>> messageRefInfoLiveData) {
        return MapLiveData.of(id -> new DiscussionInfoForCellLiveData((Id<Discussion>)id, messageRefInfoLiveData));
    }

    public String toString() {
        return String.format("DiscussionInfoMediatorLiveData[%s]", this.id);
    }
}

