/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.fx.discussions.discussion_view.DiscussionViewModel;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.mediator.DiscussionSearchResultLiveData;
import io.olvid.windows.messenger.misc.Watches;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import java.util.List;
import java.util.Optional;

public class CurrentSearchedItemLivedata
extends MediatorLiveData<Optional<DiscussionViewModel.SearchedItem>> {
    private Optional<DiscussionViewModel.SearchedItem> lastSearchedItem = Optional.empty();
    private List<DiscussionViewModel.SearchedItem> lastSearchedItemList = List.of();
    private NotificationListener<UIActionNC.RefreshCurrentSearchedItemNotification> requestPageListener = refreshCurrentSearchedItemNotification -> this.postValue(this.lastSearchedItem);
    private NotificationListener<UIActionNC.NextSearchedItemRequestNotification> nextSearchRequestListener = refreshCurrentSearchedItemNotification -> this.nextSearch();
    private NotificationListener<UIActionNC.PreviousSearchedItemRequestNotification> previousSearchRequestListener = refreshCurrentSearchedItemNotification -> this.previousSearch();

    public CurrentSearchedItemLivedata(DiscussionSearchResultLiveData discussionSearchResultLiveData) {
        super(Optional.empty());
        this.addSource(discussionSearchResultLiveData, (newValue, oldValue) -> {
            DiscussionViewModel.SearchedItem computedSearchedItem = null;
            DiscussionSearchResultLiveData.ChangeOrigin changeOrigin = newValue.origin();
            this.lastSearchedItemList = newValue.searchedItems();
            if (changeOrigin.equals((Object)DiscussionSearchResultLiveData.ChangeOrigin.SEARCH_TEXT_INPUT) && !this.lastSearchedItemList.isEmpty()) {
                computedSearchedItem = this.lastSearchedItemList.getLast();
            } else if (this.lastSearchedItem.isPresent()) {
                DiscussionViewModel.SearchedItem searchedItem = this.lastSearchedItem.get();
                Watches.Watch findCurrentItem = Watches.getInstance().start("CurrentSearchedItemLivedata::findCurrentItem");
                Optional<DiscussionViewModel.SearchedItem> updatedSearchItem = this.lastSearchedItemList.stream().filter(item -> item.idx() == searchedItem.idx()).findFirst();
                findCurrentItem.stop();
                if (updatedSearchItem.isPresent()) {
                    computedSearchedItem = updatedSearchItem.get();
                } else if (!this.lastSearchedItemList.isEmpty()) {
                    computedSearchedItem = this.lastSearchedItemList.getLast();
                }
            }
            if (computedSearchedItem == null && this.lastSearchedItem.isEmpty()) {
                return;
            }
            if (computedSearchedItem != null && computedSearchedItem.equals(this.lastSearchedItem.orElse(null))) {
                return;
            }
            this.lastSearchedItem = Optional.ofNullable(computedSearchedItem);
            this.postValue(this.lastSearchedItem);
        });
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.REFRESH_CURRENT_SEARCHED_ITEM, this.requestPageListener);
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.NEXT_SEARCHED_ITEM_REQUEST, this.nextSearchRequestListener);
        NCRegistry.getUIActionNC().subscribe(UIActionNC.UserInteractionNotificationEnumType.PREVIOUS_SEARCHED_ITEM_REQUEST, this.previousSearchRequestListener);
    }

    public void nextSearch() {
        if (this.lastSearchedItem.isEmpty() || this.lastSearchedItemList.isEmpty()) {
            return;
        }
        DiscussionViewModel.SearchedItem current = this.lastSearchedItem.get();
        int idx = this.lastSearchedItemList.indexOf(current);
        if (idx != -1 && idx < this.lastSearchedItemList.size() - 1) {
            this.lastSearchedItem = Optional.of(this.lastSearchedItemList.get(idx + 1));
        }
        this.postValue(this.lastSearchedItem);
    }

    public void previousSearch() {
        if (this.lastSearchedItem.isEmpty() || this.lastSearchedItemList.isEmpty()) {
            return;
        }
        DiscussionViewModel.SearchedItem current = this.lastSearchedItem.get();
        if (current.equals(this.lastSearchedItemList.getFirst())) {
            return;
        }
        int idx = this.lastSearchedItemList.indexOf(current);
        if (idx > 0) {
            this.lastSearchedItem = Optional.of(this.lastSearchedItemList.get(idx - 1));
        }
        this.postValue(this.lastSearchedItem);
    }
}

