/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;

public final class ContactInfoLiveData
extends MediatorLiveData<ContactInfoState>
implements LiveDataListener<Optional<ContactRef>> {
    private final MutableLiveData<Optional<Id<Contact>>> contactIdLiveData = LiveDataFactory.buildMutableLiveData(Optional.empty());

    public ContactInfoLiveData(Id<ContactRef> refId) {
        super(new ContactInfoState.Computing());
        this.addSource(refId, DbManager.getInstance().getContactRefDao().getContextLiveData(), this);
        LiveData contactInfoLiveData = DbCache.getInstance().contactInfoMapLiveData.of(Optional.empty(), this.contactIdLiveData);
        contactInfoLiveData.addListener((DataType newValue, DataType oldValue) -> {
            if (newValue.isPresent()) {
                this.postValue(new ContactInfoState.Present((ContactInfo)newValue.get()));
            } else if (oldValue.isPresent()) {
                this.postValue(new ContactInfoState.Deleted());
            }
        });
    }

    @Override
    public void onChange(Optional<ContactRef> newValue, Optional<ContactRef> oldValue) {
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        if (newValue.isEmpty()) {
            return;
        }
        Optional<Id<Contact>> contactId = newValue.get().getContactId();
        if (contactId.isEmpty()) {
            this.postValue(new ContactInfoState.Deleted());
            return;
        }
        this.contactIdLiveData.postValue(contactId);
    }

    public static MapLiveData<Id<ContactRef>, ContactInfoState> getMapLiveData() {
        return MapLiveData.of(ContactInfoLiveData::new);
    }

    public static sealed interface ContactInfoState {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        default public Optional<ContactInfo> toOptional() {
            Optional<ContactInfo> optional;
            ContactInfoState contactInfoState = this;
            Objects.requireNonNull(contactInfoState);
            ContactInfoState contactInfoState2 = contactInfoState;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Computing.class, Present.class, Deleted.class}, (Object)contactInfoState2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Computing computing = (Computing)contactInfoState2;
                    optional = Optional.empty();
                    return optional;
                }
                case 1: {
                    ContactInfo info;
                    Present present = (Present)contactInfoState2;
                    try {
                        ContactInfo contactInfo;
                        info = contactInfo = present.info();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    optional = Optional.of(info);
                    return optional;
                }
                case 2: 
            }
            Deleted deleted = (Deleted)contactInfoState2;
            optional = Optional.empty();
            return optional;
        }

        public record Computing() implements ContactInfoState
        {
        }

        public record Present(ContactInfo info) implements ContactInfoState
        {
        }

        public record Deleted() implements ContactInfoState
        {
        }
    }
}

