/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.info;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.Either;
import java.util.Optional;

public final class IdentityInfo
implements Diffable {
    public final Id<IdentityRef> refId;
    private final Either<Optional<ContactInfo>, OwnedIdentityInfo> either;

    public boolean isMe() {
        return this.either.isRight();
    }

    public Optional<ContactInfo> getContactInfo() {
        return this.either.getLeft();
    }

    public OwnedIdentityInfo getOwnedIdentityInfo() {
        return this.either.getRight();
    }

    private IdentityInfo(Id<IdentityRef> refId, Either<Optional<ContactInfo>, OwnedIdentityInfo> either) {
        this.refId = refId;
        this.either = either;
    }

    public static IdentityInfo makeContactInfo(Id<IdentityRef> refId, Optional<ContactInfo> contact) {
        return new IdentityInfo(refId, Either.left(contact));
    }

    public static IdentityInfo makeOwnedInfo(Id<IdentityRef> refId, OwnedIdentityInfo ownedIdentity) {
        return new IdentityInfo(refId, Either.right(ownedIdentity));
    }

    public static IdentityInfo makeEmpty(Id<IdentityRef> refId) {
        return new IdentityInfo(refId, Either.left(Optional.empty()));
    }

    public Optional<String> getCustomDisplayNameOrDisplayName(IdentityDetailsInfo.Format format) {
        if (this.either.isRight()) {
            return Optional.of(this.either.getRight().getCustomDisplayNameOrDisplayName(format));
        }
        return this.either.getLeft().map(info -> info.getCustomOrDisplayName(format));
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IdentityInfo) {
            IdentityInfo casted = (IdentityInfo)obj;
            boolean infoEqual = false;
            if (this.either.isRight() && this.either.isRight()) {
                infoEqual = this.either.getRight().areContentTheSame(casted.either.getRight());
            } else if (this.either.isLeft() && this.either.isLeft()) {
                if (this.either.getLeft().isPresent() && casted.either.getLeft().isPresent()) {
                    infoEqual = this.either.getLeft().get().areContentTheSame(casted.either.getLeft().get());
                }
                if (this.either.getLeft().isEmpty() && casted.either.getLeft().isEmpty()) {
                    infoEqual = true;
                }
            }
            return this.refId.equals(casted.refId) && infoEqual;
        }
        return false;
    }

    @Override
    public Object getItemId() {
        return this.refId;
    }
}

