/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.info;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.fx.misc.OptionalUtils;
import java.util.List;
import java.util.Optional;

public record IdentityDetailsInfo(Optional<String> firstName, Optional<String> lastName, Optional<String> company, Optional<String> position, Optional<String> photoUrl) {
    public IdentityDetailsInfo(IdentityDetails details) {
        this(details.getFirstName(), details.getLastName(), details.getCompany(), details.getPosition(), details.getPhotoUrl());
    }

    public IdentityDetailsInfo(JsonIdentityDetails details) {
        this(Optional.of(details.getFirstName()), Optional.ofNullable(details.getLastName()), Optional.ofNullable(details.getCompany()), Optional.ofNullable(details.getPosition()), Optional.empty());
    }

    public String getDisplayName(Format format) {
        Optional<String> firstLast = OptionalUtils.join(" ", List.of(this.firstName, this.lastName));
        Optional<String> positionAtCompany = OptionalUtils.join(" @ ", List.of(this.position, this.company));
        return switch (format.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> firstLast.orElse(null);
            case 2 -> positionAtCompany.orElse(null);
            case 0 -> {
                Optional<String> parenthesisPositionAtCompany = positionAtCompany.map(pc -> String.format("(%s)", pc));
                yield OptionalUtils.join(" ", List.of(firstLast, parenthesisPositionAtCompany)).orElse(null);
            }
            case 3 -> OptionalUtils.join(" ", List.of(this.firstName, this.lastName, this.position, this.company)).orElse(null);
        };
    }

    public static enum Format {
        FIRST_LAST_POSITION_COMPANY,
        FIRST_LAST,
        POSITION_COMPANY,
        FOR_SEARCH;

    }
}

