/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.info;

import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import java.util.Optional;

public record ContactInfo(Id<Contact> genId, byte[] bytesContactIdentity, Id<OwnedIdentity> ownedIdentityId, boolean isKeycloakManaged, boolean isActive, boolean isOneToOne, boolean isReachable, Optional<String> customDisplayName, Optional<String> customPhotoUrl, IdentityDetailsInfo detailsInfo) implements Diffable,
Comparable<ContactInfo>
{
    public ContactInfo(Contact contact, IdentityDetails identityDetails) {
        this((Id<Contact>)contact.getItemId(), contact.getBytesContactIdentity(), contact.getOwnedIdentityId(), contact.isKeycloakManaged(), contact.isActive(), contact.isOneToOne(), contact.hasChannelOrPrekey(), contact.getCustomDisplayName(), contact.getCustomPhotoUrl(), new IdentityDetailsInfo(identityDetails));
    }

    public String getDisplayName(IdentityDetailsInfo.Format format) {
        return this.detailsInfo.getDisplayName(format);
    }

    public String getCustomOrDisplayName(IdentityDetailsInfo.Format format) {
        return this.customDisplayName.orElseGet(() -> this.getDisplayName(format));
    }

    public Optional<String> getCustomPhotoUrlOrPhotoUrl() {
        return this.customPhotoUrl.or(this.detailsInfo::photoUrl);
    }

    public String getFullSearchDisplayName() {
        StringBuilder builder = new StringBuilder();
        this.customDisplayName.ifPresent(n -> builder.append((String)n).append(" "));
        builder.append(this.detailsInfo.getDisplayName(IdentityDetailsInfo.Format.FOR_SEARCH));
        return builder.toString();
    }

    @Override
    public boolean areContentTheSame(Object obj) {
        return this.equals(obj);
    }

    @Override
    public Id<Contact> getItemId() {
        return this.genId();
    }

    @Override
    public String toString() {
        return String.format("ContactInfo[%s]: %s", this.genId(), this.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST_POSITION_COMPANY));
    }

    @Override
    public int compareTo(ContactInfo o) {
        IdentityDetailsInfo.Format format = IdentityDetailsInfo.Format.FIRST_LAST;
        return this.getCustomOrDisplayName(format).compareTo(o.getCustomOrDisplayName(format));
    }
}

