/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class SwitchMapLiveData<SourceDataType, DestinationDataType>
extends MutableLiveData<DestinationDataType>
implements LiveDataListener<SourceDataType> {
    protected final LiveData<SourceDataType> sourceLiveData;
    private final Function<SourceDataType, LiveData<DestinationDataType>> switchMapFunction;
    private LiveData<DestinationDataType> currentLiveData;
    private final LiveDataListener<DestinationDataType> internalListener = this::internalOnChange;
    private Optional<BiFunction<SourceDataType, SourceDataType, Boolean>> sourceDataDiffMethod = Optional.empty();

    public SwitchMapLiveData(LiveData<SourceDataType> sourceLiveData, Function<SourceDataType, LiveData<DestinationDataType>> switchMapFunction, BiFunction<SourceDataType, SourceDataType, Boolean> sourceDataDiffMethod) {
        this.sourceLiveData = sourceLiveData;
        this.switchMapFunction = switchMapFunction;
        this.currentLiveData = null;
        this.sourceDataDiffMethod = Optional.ofNullable(sourceDataDiffMethod);
    }

    public SwitchMapLiveData(LiveData<SourceDataType> sourceLiveData, Function<SourceDataType, LiveData<DestinationDataType>> switchMapFunction) {
        this.sourceLiveData = sourceLiveData;
        this.switchMapFunction = switchMapFunction;
        this.currentLiveData = null;
    }

    @Override
    public void addListener(LiveDataListener<DestinationDataType> listener) {
        if (this.registeredListeners.isEmpty()) {
            this.sourceLiveData.addListener(this);
        }
        super.addListener(listener);
    }

    @Override
    public void removeListener(LiveDataListener<DestinationDataType> listener) {
        super.removeListener(listener);
        if (this.registeredListeners.isEmpty()) {
            this.sourceLiveData.removeListener(this);
        }
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        this.sourceLiveData.removeListener(this);
    }

    @Override
    public void onChange(SourceDataType newValue, SourceDataType oldValue) {
        if (this.sourceDataDiffMethod.isPresent()) {
            this.applyChange(this.sourceDataDiffMethod.get().apply(newValue, oldValue), newValue);
        } else {
            this.applyChange(Objects.equals(newValue, oldValue), newValue);
        }
    }

    private void applyChange(boolean isSourceDataValueTheSame, SourceDataType newValue) {
        if (isSourceDataValueTheSame) {
            if (this.currentLiveData == null) {
                this.postValue(null);
            } else {
                this.postValue(this.currentLiveData.getValue());
            }
        } else {
            if (this.currentLiveData != null) {
                this.currentLiveData.removeListener(this.internalListener);
                this.currentLiveData = null;
            }
            this.currentLiveData = this.switchMapFunction.apply(newValue);
            SwitchMapLiveData.debug(this, "applyChange", "get %s", this.currentLiveData);
            if (this.currentLiveData != null) {
                this.currentLiveData.addListener(this.internalListener);
            } else {
                this.postValue(null);
            }
        }
    }

    private void internalOnChange(DestinationDataType newValue, DestinationDataType oldValue) {
        this.postValue(newValue);
    }
}

