/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Pair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MediatorLiveData<Value>
extends MutableLiveData<Value> {
    private final Map<Object, Source<?>> sources = new ConcurrentHashMap();

    public MediatorLiveData(Value initialValue) {
        super(initialValue);
        this.loggerInstance = new AppLogger(this.getClass());
    }

    @Override
    public void addListener(LiveDataListener<Value> listener) {
        super.addListener(listener);
        this.sources.values().forEach(Source::plug);
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        this.sources.values().forEach(Source::unplug);
    }

    @Override
    public void removeListener(LiveDataListener<Value> listener) {
        super.removeListener(listener);
        if (!this.hasObservers()) {
            this.sources.values().forEach(Source::unplug);
        }
    }

    private <V> void addSource(Object sourceKey, Source<V> newSource, LiveDataListener<V> liveDataListener) {
        Source<V> knownSource = this.sources.putIfAbsent(sourceKey, newSource);
        if (knownSource != null && knownSource.liveDataListener != liveDataListener) {
            throw new IllegalArgumentException("This source was already added with the different observer");
        }
        if (knownSource != null) {
            return;
        }
        if (this.hasObservers()) {
            newSource.plug();
        }
    }

    public <V> void addSource(final LiveData<V> sourceToAdd, LiveDataListener<V> liveDataListener) {
        Source source = new Source<V>(this, liveDataListener){

            @Override
            protected void addListener(LiveDataListener<V> listener) {
                sourceToAdd.addListener(listener);
            }

            @Override
            protected void removeListener(LiveDataListener<V> listener) {
                sourceToAdd.removeListener(listener);
            }
        };
        this.addSource(sourceToAdd, source, liveDataListener);
    }

    public <K, V> void addSource(final K key, final MapLiveData<K, V> mapLiveData, LiveDataListener<V> liveDataListener) {
        Source source = new Source<V>(this, liveDataListener){

            @Override
            protected void addListener(LiveDataListener<V> listener) {
                mapLiveData.addListener(key, listener);
            }

            @Override
            protected void removeListener(LiveDataListener<V> listener) {
                mapLiveData.removeListener(key, listener);
            }
        };
        Pair<K, MapLiveData<K, V>> sourceKey = Pair.of(key, mapLiveData);
        this.addSource(sourceKey, source, liveDataListener);
    }

    public void removeSourceImpl(Object sourceKey) {
        Source<?> source = this.sources.remove(sourceKey);
        if (source != null) {
            source.unplug();
        }
    }

    public <V> void removeSource(LiveData<V> toRemove) {
        this.removeSourceImpl(toRemove);
    }

    public <K, V> void removeSource(K key, MapLiveData<K, V> mapLiveData) {
        Pair<K, MapLiveData<K, V>> sourceKey = Pair.of(key, mapLiveData);
        this.removeSourceImpl(sourceKey);
    }

    public void clearSources() {
        for (Source<?> source : this.sources.values()) {
            source.unplug();
        }
        this.sources.clear();
    }

    protected static abstract class Source<Value>
    implements LiveDataListener<Value> {
        final LiveDataListener<Value> liveDataListener;
        private boolean isPlugged = false;

        protected Source(LiveDataListener<Value> liveDataListener) {
            this.liveDataListener = liveDataListener;
        }

        protected abstract void addListener(LiveDataListener<Value> var1);

        protected abstract void removeListener(LiveDataListener<Value> var1);

        void plug() {
            if (this.isPlugged) {
                return;
            }
            this.addListener(this);
            this.isPlugged = true;
        }

        void unplug() {
            if (!this.isPlugged) {
                return;
            }
            this.removeListener(this);
            this.isPlugged = false;
        }

        @Override
        public void onChange(Value newValue, Value oldValue) {
            if (this.liveDataListener != null) {
                this.liveDataListener.onChange(newValue, oldValue);
            }
        }
    }
}

