/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SwitchMapLiveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ContextLiveData<T extends AbstractTableGenerated<T>>
extends SwitchMapLiveData<Set<Id<T>>, List<T>>
implements MapLiveData<Id<T>, Optional<T>> {
    private final OlvidDao<T> dao;
    private final Map<Id<T>, List<Listener<T>>> listenersMap = new HashMap<Id<T>, List<Listener<T>>>();
    private final LiveDataListener<List<T>> internalListener = this::onChange;
    private boolean isPlugged = false;

    public ContextLiveData(OlvidDao<T> dao, Function<Set<Id<T>>, LiveData<List<T>>> computeLiveData) {
        super(new MutableLiveData(Set.of()), computeLiveData);
        this.dao = dao;
    }

    @Override
    public synchronized void addListener(Id<T> id, LiveDataListener<Optional<T>> listener) {
        List listeners = this.listenersMap.computeIfAbsent(id, i -> new ArrayList());
        listeners.add(new Listener<T>(listener));
        Set<Id<T>> keys = Set.copyOf(this.listenersMap.keySet());
        LiveData.debug(this, "addListener", " for %s, observedKey=" + String.valueOf(id), keys);
        this.sourceLiveData.postValue(keys);
        if (!this.isPlugged) {
            this.addListener(this.internalListener);
            this.isPlugged = true;
        }
    }

    @Override
    public synchronized void removeListener(Id<T> id, LiveDataListener<Optional<T>> listener) {
        List<Listener<T>> listeners = this.listenersMap.get(id);
        if (listeners == null) {
            return;
        }
        listeners.removeIf(l -> l.listener.equals(listener));
        if (listeners.isEmpty()) {
            this.listenersMap.remove(id);
        }
        LiveData.debug(this, "removeListener", " for %s, observedKey=" + String.valueOf(id), this.listenersMap.keySet());
        if (this.listenersMap.isEmpty()) {
            this.removeListener(this.internalListener);
            this.isPlugged = false;
        }
    }

    @Override
    public Optional<T> getCurrentValue(Id<T> key) {
        return ((List)this.getValue()).stream().filter(x -> ((Id)x.getItemId()).equals(key)).findFirst();
    }

    @Override
    private synchronized void onChange(List<T> newValues, List<T> oldValues) {
        LiveData.debug(this, "internalListener", "%s -> %s", oldValues, newValues);
        if (newValues == null) {
            return;
        }
        Map newValueMap = newValues.stream().collect(Collectors.toMap(AbstractTableGenerated::getItemId, Function.identity()));
        Map<Id<T>, List<Listener<T>>> listenersMapCopy = Map.copyOf(this.listenersMap);
        for (Id<T> id : listenersMapCopy.keySet()) {
            Optional<AbstractTableGenerated> newValue = Optional.ofNullable((AbstractTableGenerated)newValueMap.get(id));
            List<Listener> listeners = List.copyOf((Collection)listenersMapCopy.get(id));
            for (Listener listener : listeners) {
                listener.listener.onChange(newValue, listener.previousValue);
                listener.previousValue = newValue;
            }
        }
    }

    public String toString() {
        return String.format("ContextLiveData[%s:%s]", this.dao.getDataClass().getSimpleName(), String.join((CharSequence)", ", ((Set)this.sourceLiveData.getValue()).stream().map(Id::getDescription).toList()));
    }

    private static final class Listener<T> {
        private Optional<T> previousValue = Optional.empty();
        private final LiveDataListener<Optional<T>> listener;

        public Listener(LiveDataListener<Optional<T>> listener) {
            this.listener = listener;
        }
    }
}

