/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.transfer_restricted_authentication;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocolNC;
import io.olvid.windows.messenger.keycloak.protocol.ProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.TransferRestrictedAuthenticationProtocol;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import java.util.Optional;
import java.util.UUID;

public class TransferRestrictedAuthenticationProtocolContext
implements ProtocolContext {
    public final KeycloakProtocolNC notificationCenter = new KeycloakProtocolNC();
    public final AuthenticationProtocol authenticationProtocol;
    public final BytesKey dummyOwnedIdentity;
    public final TransferApi.Step transferStep;
    public final UUID dialogUUID;
    public final Encoded encodedElements;
    public final String sas;
    public final String sessionNumber;
    private final NotificationListener<TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification> protocolNotificationListener;
    private final TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotificationEnum[] notifications = TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotificationEnum.values();

    public TransferRestrictedAuthenticationProtocolContext(String keycloakServerUrl, String clientId, String clientSecret, String sas, String sessionNumber, BytesKey dummyOwnedIdentity, TransferApi.Step transferStep, UUID dialogUUID, Encoded encodedElements, NotificationListener<TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification> notificationListener) {
        this.authenticationProtocol = AuthenticationProtocol.of(keycloakServerUrl, clientId, Optional.ofNullable(clientSecret), KeycloakManager.RedirectType.RESTRICTED, Optional.empty(), Either.left(this.notificationCenter));
        this.sas = sas;
        this.sessionNumber = sessionNumber;
        this.dummyOwnedIdentity = dummyOwnedIdentity;
        this.transferStep = transferStep;
        this.dialogUUID = dialogUUID;
        this.protocolNotificationListener = notificationListener;
        this.encodedElements = encodedElements;
        this.notificationCenter.subscribe(this.notifications, this.protocolNotificationListener);
        this.notificationCenter.startCenter();
    }

    public static TransferRestrictedAuthenticationProtocolContext of(String keycloakServerUrl, String clientId, String clientSecret, String sas, String sessionNumber, BytesKey dummyOwnedIdentity, TransferApi.Step transferStep, UUID dialogUUID, Encoded encodedElements, NotificationListener<TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification> notificationListener) {
        return new TransferRestrictedAuthenticationProtocolContext(keycloakServerUrl, clientId, clientSecret, sas, sessionNumber, dummyOwnedIdentity, transferStep, dialogUUID, encodedElements, notificationListener);
    }

    @Override
    public void clear() {
        ((AuthenticationProtocolContext)this.authenticationProtocol.context).notificationCenter.unSubscribe(this.notifications, this.protocolNotificationListener);
    }

    public void fireBuildingAuthenticationUrl() {
        this.notificationCenter.postNotification(TransferRestrictedAuthenticationProtocol.BuildingAuthenticationUrl.of());
    }

    public void fireWaitingForUserAuthentication(String authUrl) {
        this.notificationCenter.postNotification(TransferRestrictedAuthenticationProtocol.WaitingForTransferUserAuthentication.of(authUrl));
    }

    public void fireValidatingAuthentication() {
        this.notificationCenter.postNotification(TransferRestrictedAuthenticationProtocol.VerifyingAuthenticationProofForTransfer.of());
    }

    public void fireTransferAuthenticationSuccess() {
        this.notificationCenter.postNotification(TransferRestrictedAuthenticationProtocol.TransferAuthenticationSuccess.of());
    }

    public void fireTransferAuthenticationFailed(AbstractStep<TransferRestrictedAuthenticationProtocolContext, KeycloakUtils.RfcError> step) {
        this.notificationCenter.postNotification(TransferRestrictedAuthenticationProtocol.TransferAuthenticationFailure.of(step.getFailReason()));
    }
}

