/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.step;

import io.olvid.windows.messenger.keycloak.protocol.ProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class WaitingStep<C extends ProtocolContext, F extends ProtocolContext.FailReason>
extends AbstractStep<C, F> {
    private final AppLogger logger = new AppLogger(this.getClass());
    protected final AtomicBoolean stopWait = new AtomicBoolean(false);
    private static final int TIME_OUT_MS = 900000;
    private static final int POLL_TIME_MS = 250;
    private int waitedTime = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWait() {
        while (!this.stopWait.get() && this.waitedTime < 900000) {
            this.logger.debug("WaitingStep::execute waiting for %s ...", this.getClass().getSimpleName());
            WaitingStep waitingStep = this;
            synchronized (waitingStep) {
                try {
                    this.wait(250L);
                    this.waitedTime += 250;
                }
                catch (InterruptedException e) {
                    this.logger.debug("WaitingStep::execute thread interrupted for %s...", this.getClass().getSimpleName());
                }
            }
        }
    }

    @Override
    public void interrupt() {
        this.logger.debug("WaitingStep::interrupt internally interrupted for %s...", this.getClass().getSimpleName());
        this.stopWait.set(true);
        super.interrupt();
    }
}

