/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.enrollement.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.EnrollementProtocol;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.EnrollementProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.BindIdentityStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.keycloak.protocol.step.WaitingStep;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RegisterIdentityToEngineStep
extends WaitingStep<EnrollementProtocolContext, KeycloakUtils.RfcError>
implements NotificationListener<EnrollementProtocol.KeycloakEnrollementInputNotification> {
    private final AppLogger logger = new AppLogger(RegisterIdentityToEngineStep.class);
    private EnrollementProtocolContext context;
    private final AtomicBoolean subTaskFailed = new AtomicBoolean(false);

    @Override
    public AbstractStep.Result execute(EnrollementProtocolContext protocolContext) {
        this.context = protocolContext;
        this.context.notificationCenter.subscribe(EnrollementProtocol.KeycloakEnrollementProtocolUserInputNotification.SHARE_IDENTITY_TO_BIND, (NotificationListener)this);
        this.executeWait();
        return this.subTaskFailed.get() ? AbstractStep.Result.FAILED : AbstractStep.Result.SUCCESS;
    }

    @Override
    public AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return new BindIdentityStep();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onReceived(EnrollementProtocol.KeycloakEnrollementInputNotification keycloakEnrollementInputNotification) {
        OwnedIdentity ownedIdentityToSave;
        this.logger.debug("RegisterIdentityToEngineStep::onReceived KeycloakEnrollementInputNotification --> %s", keycloakEnrollementInputNotification.getNotificationType());
        EnrollementProtocol.KeycloakEnrollementInputNotification keycloakEnrollementInputNotification2 = keycloakEnrollementInputNotification;
        Objects.requireNonNull(keycloakEnrollementInputNotification2);
        EnrollementProtocol.KeycloakEnrollementInputNotification keycloakEnrollementInputNotification3 = keycloakEnrollementInputNotification2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnrollementProtocol.ShareIdentityToBindInputNotification.class}, (Object)keycloakEnrollementInputNotification3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        EnrollementProtocol.ShareIdentityToBindInputNotification shareIdentityToBindInputNotification = (EnrollementProtocol.ShareIdentityToBindInputNotification)keycloakEnrollementInputNotification3;
        Optional<BytesKey> ownedIdBytesOpt = shareIdentityToBindInputNotification.ownedIdentity();
        if (ownedIdBytesOpt.isEmpty()) {
            OwnedIdentity ownedidentity = OwnedIdentityApi.createIdentitySync(this.context.getOlvidServerUrl().orElse(null), null, this.context.getFirstName(), this.context.getLastName(), this.context.getCompany(), this.context.getPosition(), null);
            if (ownedidentity == null) {
                this.logger.error("RegisterIdentityToEngineStep::onReceived couldn't create owned identity");
                this.stopWait.set(true);
                this.subTaskFailed.set(true);
                this.failReasonOpt = KeycloakUtils.RfcError.RFC_INTERNAL_ERROR;
                return;
            }
            ownedIdentityToSave = ownedidentity;
            this.context.setOwnedIdentityCreated();
        } else {
            ownedIdentityToSave = DbManager.getInstance().getOwnedIdentityDao().get(ownedIdBytesOpt.get().bytes);
        }
        this.context.setOwnedIdentity(ownedIdentityToSave);
        try {
            if (!KeycloakManager.getInstance().registerKeycloakManagedIdentity(ownedIdentityToSave.getBytesOwnedIdentity(), ((AuthenticationProtocolContext)this.context.authenticationProtocol.context).serverUrl, ((AuthenticationProtocolContext)this.context.authenticationProtocol.context).clientId, ((AuthenticationProtocolContext)this.context.authenticationProtocol.context).clientSecret.orElse(null), ((AuthenticationProtocolContext)this.context.authenticationProtocol.context).getJsonWebKeySet(), this.context.getSignatureKey(), KeycloakUtils.getJsonObjectMapper().writeValueAsString((Object)((AuthenticationProtocolContext)this.context.authenticationProtocol.context).getSimpleAuthState()), null, 0L, true, this.context.getTransferRestricted())) {
                this.subTaskFailed.set(true);
                this.failReasonOpt = KeycloakUtils.RfcError.RFC_INTERNAL_ERROR;
            }
        }
        catch (JsonProcessingException e) {
            this.subTaskFailed.set(true);
            this.failReasonOpt = KeycloakUtils.RfcError.RFC_INTERNAL_ERROR;
        }
        this.stopWait.set(true);
    }
}

