/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.enrollement.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.pojos.MeResponseJson;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.EnrollementProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.RegisterIdentityToEngineStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Pair;
import java.util.Optional;
import org.jose4j.jwk.JsonWebKey;

public final class GetOwnedDetailsStep
extends AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> {
    final AppLogger logger = new AppLogger(GetOwnedDetailsStep.class);

    @Override
    public AbstractStep.Result execute(EnrollementProtocolContext protocolContext) {
        KeycloakCallReturn<MeResponseJson> codeWithMeResponse = KeycloakUtils.getOwnDetails(null, ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).serverUrl, ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).clientSecret.orElse(null), ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).clientId, null, ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).getSimpleAuthState());
        MeResponseJson response = codeWithMeResponse.getResult();
        if (codeWithMeResponse.isSuccess()) {
            KeycloakCallReturn<Pair<String, JsonWebKey>> detailsJsonStringAndSignatureKey = KeycloakUtils.verifyDetailsSignature(response.signature, ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).getJsonWebKeySet(), null);
            if (detailsJsonStringAndSignatureKey.isSuccess()) {
                Optional<JsonKeycloakUserDetails> details;
                try {
                    details = Optional.ofNullable((JsonKeycloakUserDetails)KeycloakUtils.getJsonObjectMapper().readValue(detailsJsonStringAndSignatureKey.getResult().getFirst(), JsonKeycloakUserDetails.class));
                }
                catch (JsonProcessingException e) {
                    this.logger.error("GetOwnedDetailsStep::execute can not read id to bind json details' ");
                    return AbstractStep.Result.FAILED;
                }
                if (details.isEmpty()) {
                    this.failReasonOpt = KeycloakUtils.RfcError.RFC_INTERNAL_ERROR;
                    return AbstractStep.Result.FAILED;
                }
                JsonKeycloakUserDetails jsonKeycloakUserDetails = details.get();
                protocolContext.setFirstName(jsonKeycloakUserDetails.getFirstName());
                protocolContext.setLastName(jsonKeycloakUserDetails.getLastName());
                protocolContext.setCompany(jsonKeycloakUserDetails.getCompany());
                protocolContext.setPosition(jsonKeycloakUserDetails.getPosition());
                protocolContext.setOlvidServerUrl(Optional.ofNullable(response.server));
                protocolContext.setTransferRestricted(response.transferRestricted != null && response.transferRestricted != false);
                protocolContext.setSignatureKey(detailsJsonStringAndSignatureKey.getResult().getSecond());
                protocolContext.setDetails(jsonKeycloakUserDetails);
                return AbstractStep.Result.SUCCESS;
            }
            this.logger.error("GetOwnedDetailsStep::execute invalid signature in retrieved details:");
            this.failReasonOpt = detailsJsonStringAndSignatureKey.getError();
            return AbstractStep.Result.FAILED;
        }
        this.logger.error("GetOwnedDetailsStep::execute unknown response");
        this.failReasonOpt = codeWithMeResponse.getError();
        return AbstractStep.Result.FAILED;
    }

    @Override
    public AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return new RegisterIdentityToEngineStep();
    }
}

