/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.enrollement.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.EnrollementProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.logger.AppLogger;

public final class BindIdentityStep
extends AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> {
    private final AppLogger logger = new AppLogger(BindIdentityStep.class);

    @Override
    public AbstractStep.Result execute(EnrollementProtocolContext protocolContext) {
        KeycloakCallReturn<Integer> ret = KeycloakManager.getInstance().uploadOwnIdentity(protocolContext.getOwnedIdentity().getBytesOwnedIdentity());
        if (ret.isSuccess()) {
            KeycloakCallReturn<Boolean> bindCallResult;
            try {
                bindCallResult = KeycloakManager.getInstance().bindOwnedIdentityToKeycloakInEngine(protocolContext.getOwnedIdentity().getBytesOwnedIdentity(), ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).serverUrl, ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).clientId, ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).clientSecret.orElse(null), ((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).getJsonWebKeySet(), protocolContext.getSignatureKey(), KeycloakUtils.getJsonObjectMapper().writeValueAsString((Object)((AuthenticationProtocolContext)protocolContext.authenticationProtocol.context).getSimpleAuthState()), 0L, 0L, protocolContext.getDetails().getId(), protocolContext.getTransferRestricted());
            }
            catch (JsonProcessingException e) {
                this.failReasonOpt = KeycloakUtils.RfcError.RFC_INTERNAL_ERROR;
                return AbstractStep.Result.FAILED;
            }
            if (bindCallResult.isSuccess()) {
                this.logger.info("BindIdentityStep::execute : Binding successful");
                return AbstractStep.Result.SUCCESS;
            }
            this.failReasonOpt = bindCallResult.getError();
            this.logger.error("BindIdentityStep::execute : Binding failed");
        } else {
            this.logger.error("BindIdentityStep::execute : request failed failed return : %s", ret.getError());
            this.failReasonOpt = ret.getError();
            KeycloakManager.getInstance().unregisterKeycloakManagedIdentity(protocolContext.getOwnedIdentity().getBytesOwnedIdentity());
            OwnedIdentity toDelete = DbManager.getInstance().getOwnedIdentityDao().get(protocolContext.getOwnedIdentity().getBytesOwnedIdentity());
            if (toDelete != null && protocolContext.wasIdentityCreated()) {
                OwnedIdentityApi.deleteOwnedIdentity(toDelete);
            }
        }
        return AbstractStep.Result.FAILED;
    }

    @Override
    public AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return null;
    }
}

