/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.enrollement.steps;

import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.EnrollementProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.GetOwnedDetailsStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.keycloak.protocol.step.WaitingStep;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AuthenticationChildProtocolStep
extends WaitingStep<EnrollementProtocolContext, KeycloakUtils.RfcError>
implements NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification> {
    private final AppLogger logger = new AppLogger(AuthenticationChildProtocolStep.class);
    AuthenticationProtocol authenticationProtocolInstance;
    EnrollementProtocolContext context;
    private final AtomicBoolean subTaskFailed = new AtomicBoolean(false);

    @Override
    public AbstractStep.Result execute(EnrollementProtocolContext protocolContext) {
        this.context = protocolContext;
        this.authenticationProtocolInstance = protocolContext.authenticationProtocol;
        ((AuthenticationProtocolContext)this.authenticationProtocolInstance.context).subscribe(this);
        this.authenticationProtocolInstance.start();
        this.executeWait();
        this.logger.debug("AuthenticationChildProtocolStep::executeWait stopped waiting for notification...");
        ((AuthenticationProtocolContext)this.authenticationProtocolInstance.context).unsubscribe();
        return this.subTaskFailed.get() ? AbstractStep.Result.FAILED : AbstractStep.Result.SUCCESS;
    }

    @Override
    public void onReceived(AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification) {
        this.logger.debug("AuthenticationChildProtocolStep::onReceived authentication notification --> %s", keycloakAuthenticationNotification);
        AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification2 = keycloakAuthenticationNotification;
        Objects.requireNonNull(keycloakAuthenticationNotification2);
        AuthenticationProtocol.KeycloakAuthenticationNotification keycloakAuthenticationNotification3 = keycloakAuthenticationNotification2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.DiscoveringNotification.class, AuthenticationProtocol.WaitingForAccessTokenNotification.class, AuthenticationProtocol.WaitingForAuthorizationCodeNotification.class, AuthenticationProtocol.AuthenticationSuccessNotification.class, AuthenticationProtocol.AuthenticationProtocolFailed.class}, (Object)keycloakAuthenticationNotification3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AuthenticationProtocol.DiscoveringNotification discoveringNotification = (AuthenticationProtocol.DiscoveringNotification)keycloakAuthenticationNotification3;
                this.context.fireWaitingForAuthenticationUrl();
                break;
            }
            case 1: {
                AuthenticationProtocol.WaitingForAccessTokenNotification waitingForAccessTokenNotification = (AuthenticationProtocol.WaitingForAccessTokenNotification)keycloakAuthenticationNotification3;
                break;
            }
            case 2: {
                AuthenticationProtocol.WaitingForAuthorizationCodeNotification waitingForAuthorizationCodeNotification = (AuthenticationProtocol.WaitingForAuthorizationCodeNotification)keycloakAuthenticationNotification3;
                this.context.fireWaitingForAuthenticationNotification(waitingForAuthorizationCodeNotification.authenticationUrl());
                break;
            }
            case 3: {
                AuthenticationProtocol.AuthenticationSuccessNotification authenticationSuccessNotification = (AuthenticationProtocol.AuthenticationSuccessNotification)keycloakAuthenticationNotification3;
                this.stopWait.set(true);
                break;
            }
            case 4: {
                AuthenticationProtocol.AuthenticationProtocolFailed authenticationProtocolFailed = (AuthenticationProtocol.AuthenticationProtocolFailed)keycloakAuthenticationNotification3;
                this.subTaskFailed.set(true);
                this.failReasonOpt = authenticationProtocolFailed.failMessage();
                this.context.fireEnrollementFailedNotification((KeycloakUtils.RfcError)this.failReasonOpt);
                this.stopWait.set(true);
            }
        }
    }

    @Override
    public AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return new GetOwnedDetailsStep();
    }

    @Override
    public void interrupt() {
        this.authenticationProtocolInstance.stop();
        super.interrupt();
    }
}

