/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.authentication.steps;

import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.authentication.steps.HandleRedirectStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.misc.Pair;

public final class BuildAuthenticationURLStep
extends AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> {
    @Override
    public AbstractStep.Result execute(AuthenticationProtocolContext context) {
        Pair<String, String> challenge = KeycloakUtils.generateChallenge();
        KeycloakCallReturn<String> authRequest = KeycloakUtils.buildAuthRequest(context.redirectType, context.serverUrl, context.clientId, challenge.getSecond());
        if (authRequest.isSuccess()) {
            context.setChallenge(challenge);
            context.setAuthenticationUrl(authRequest.getResult());
            return AbstractStep.Result.SUCCESS;
        }
        this.failReasonOpt = authRequest.getError();
        return AbstractStep.Result.FAILED;
    }

    @Override
    public AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return new HandleRedirectStep();
    }
}

