/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.authentication;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocolNC;
import io.olvid.windows.messenger.keycloak.protocol.ProtocolContext;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import java.util.Optional;
import org.jose4j.jwk.JsonWebKeySet;

public final class AuthenticationProtocolContext
implements ProtocolContext {
    public final String serverUrl;
    public final String clientId;
    public final Optional<String> clientSecret;
    public final KeycloakManager.RedirectType redirectType;
    private JsonWebKeySet jsonWebKeySet;
    private Pair<String, String> challenge;
    private String authorizationCode;
    private SimpleAuthState simpleAuthState;
    private String authenticationUrl;
    private Optional<BytesKey> ownedIdentityBytes = Optional.empty();
    private Optional<String> olvidServerUrl = Optional.empty();
    public final KeycloakProtocolNC notificationCenter;
    private NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification> authenticationNotificationListener;
    private final AuthenticationProtocol.KeycloakAuthenticationProtocolNotification[] notificationsToListen = AuthenticationProtocol.KeycloakAuthenticationProtocolNotification.values();

    public AuthenticationProtocolContext(String serverUrl, String clientId, Optional<String> clientSecret, KeycloakManager.RedirectType redirectType, Optional<BytesKey> ownedIdentityBytes, Either<KeycloakProtocolNC, NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification>> centerOrListener) {
        if (centerOrListener.isLeft()) {
            this.notificationCenter = centerOrListener.getLeft();
        } else {
            this.notificationCenter = new KeycloakProtocolNC();
            this.subscribe(centerOrListener.getRight());
            this.notificationCenter.startCenter();
        }
        this.serverUrl = serverUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectType = redirectType;
        this.ownedIdentityBytes = ownedIdentityBytes;
    }

    public static AuthenticationProtocolContext of(String serverUrl, String clientId, Optional<String> clientSecret, KeycloakManager.RedirectType redirectType, Optional<BytesKey> ownedIdentityBytes, Either<KeycloakProtocolNC, NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification>> notificationCenter) {
        return new AuthenticationProtocolContext(serverUrl, clientId, clientSecret, redirectType, ownedIdentityBytes, notificationCenter);
    }

    @Override
    public void clear() {
        this.unsubscribe();
    }

    public void subscribe(NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification> notificationListener) {
        this.authenticationNotificationListener = notificationListener;
        this.notificationCenter.subscribe(this.notificationsToListen, this.authenticationNotificationListener);
    }

    public void unsubscribe() {
        this.notificationCenter.unSubscribe(this.notificationsToListen, this.authenticationNotificationListener);
        this.authenticationNotificationListener = null;
    }

    public Optional<BytesKey> getOwnedIdentityBytes() {
        return this.ownedIdentityBytes;
    }

    public void setAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
    }

    public String getAuthenticationUrl() {
        return this.authenticationUrl;
    }

    public SimpleAuthState getSimpleAuthState() {
        return this.simpleAuthState;
    }

    public void setSimpleAuthState(SimpleAuthState simpleAuthState) {
        this.simpleAuthState = simpleAuthState;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public Pair<String, String> getChallenge() {
        if (this.challenge == null) {
            throw new IllegalStateException("AuthenticationProtocolContext::getChallenge challenge null");
        }
        return this.challenge;
    }

    public void setChallenge(Pair<String, String> challenge) {
        this.challenge = challenge;
    }

    public JsonWebKeySet getJsonWebKeySet() {
        if (this.jsonWebKeySet == null) {
            throw new IllegalStateException("AuthenticationProtocolContext::getChallenge jsonWebKeySet null");
        }
        return this.jsonWebKeySet;
    }

    public void setJsonWebKeySet(JsonWebKeySet jsonWebKeySetOptional) {
        this.jsonWebKeySet = jsonWebKeySetOptional;
    }

    public Optional<String> getOlvidServerUrl() {
        return this.olvidServerUrl;
    }

    public void setOlvidServerUrl(Optional<String> olvidServerUrl) {
        this.olvidServerUrl = olvidServerUrl;
    }

    public void fireDiscoveringStateNotification() {
        this.notificationCenter.postNotification(AuthenticationProtocol.DiscoveringNotification.of());
    }

    public void fireWaitingForRedirectNotification(String authUrl) {
        this.notificationCenter.postNotification(AuthenticationProtocol.WaitingForAuthorizationCodeNotification.of(authUrl));
    }

    public void fireWaitingForAccessToken() {
        this.notificationCenter.postNotification(AuthenticationProtocol.WaitingForAccessTokenNotification.of());
    }

    public void fireAuthenticationSuccess() {
        try {
            Optional<String> serializeAuthState = Optional.ofNullable(EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)this.simpleAuthState));
            this.notificationCenter.postNotification(AuthenticationProtocol.AuthenticationSuccessNotification.of(serializeAuthState));
        }
        catch (JsonProcessingException e) {
            this.fireAuthenticationFailedNotification(KeycloakUtils.RfcError.RFC_INTERNAL_ERROR);
        }
    }

    public void fireAuthenticationFailedNotification(KeycloakUtils.RfcError rfcError) {
        this.notificationCenter.postNotification(AuthenticationProtocol.AuthenticationProtocolFailed.of(rfcError));
    }
}

