/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.AbstractProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocol;
import io.olvid.windows.messenger.keycloak.protocol.StepsExecutor;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.keycloak.protocol.transfer_restricted_authentication.TransferRestrictedAuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.transfer_restricted_authentication.steps.TransferRestrictedAuthenticationChildProtocolStep;
import io.olvid.windows.messenger.keycloak.protocol.transfer_restricted_authentication.steps.ValidateAuthenticationStep;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import java.util.Optional;
import java.util.UUID;

public final class TransferRestrictedAuthenticationProtocol
extends AbstractProtocol<TransferRestrictedAuthenticationProtocolContext, KeycloakUtils.RfcError>
implements KeycloakProtocol {
    public TransferRestrictedAuthenticationProtocol(String keycloakServerUrl, String clientId, String clientSecret, String sas, String sessionNumber, BytesKey dummyOwnedIdentity, TransferApi.Step transferStep, UUID dialogUUID, Encoded encodedElements, NotificationListener<KeycloakTransfertRestrictedAuthenticationNotification> notificationListener) {
        this.context = TransferRestrictedAuthenticationProtocolContext.of(keycloakServerUrl, clientId, clientSecret, sas, sessionNumber, dummyOwnedIdentity, transferStep, dialogUUID, encodedElements, notificationListener);
        this.stepsExecutor = new StepsExecutor<TransferRestrictedAuthenticationProtocolContext, KeycloakUtils.RfcError>((TransferRestrictedAuthenticationProtocolContext)this.context, new TransferRestrictedAuthenticationChildProtocolStep(), this);
    }

    public static TransferRestrictedAuthenticationProtocol of(String keycloakServerUrl, String clientId, Optional<String> clientSecret, String sas, String sessionNumber, BytesKey dummyOwnedIdentity, TransferApi.Step transferStep, UUID dialogUUID, Encoded encodedElements, NotificationListener<KeycloakTransfertRestrictedAuthenticationNotification> notificationListener) {
        return new TransferRestrictedAuthenticationProtocol(keycloakServerUrl, clientId, clientSecret.orElse(null), sas, sessionNumber, dummyOwnedIdentity, transferStep, dialogUUID, encodedElements, notificationListener);
    }

    @Override
    public void notifyProtocolStarted() {
        ((TransferRestrictedAuthenticationProtocolContext)this.context).fireBuildingAuthenticationUrl();
    }

    @Override
    public void postStepNotification(AbstractStep<TransferRestrictedAuthenticationProtocolContext, KeycloakUtils.RfcError> step) {
        if (step instanceof TransferRestrictedAuthenticationChildProtocolStep) {
            ((TransferRestrictedAuthenticationProtocolContext)this.context).fireValidatingAuthentication();
        } else if (step instanceof ValidateAuthenticationStep) {
            ((TransferRestrictedAuthenticationProtocolContext)this.context).fireTransferAuthenticationSuccess();
        }
    }

    @Override
    public void stepFailed(AbstractStep<TransferRestrictedAuthenticationProtocolContext, KeycloakUtils.RfcError> step) {
        ((TransferRestrictedAuthenticationProtocolContext)this.context).fireTransferAuthenticationFailed(step);
    }

    public record WaitingForTransferUserAuthentication(String authRequest) implements KeycloakTransfertRestrictedAuthenticationNotification
    {
        public static WaitingForTransferUserAuthentication of(String authRequest) {
            return new WaitingForTransferUserAuthentication(authRequest);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakTransfertRestrictedAuthenticationNotificationEnum.WAITING_FOR_AUTHENTICATION_RESULT;
        }
    }

    public record BuildingAuthenticationUrl() implements KeycloakTransfertRestrictedAuthenticationNotification
    {
        public static VerifyingAuthenticationProofForTransfer of() {
            return new VerifyingAuthenticationProofForTransfer();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakTransfertRestrictedAuthenticationNotificationEnum.VERIFYING_SIGNATURE;
        }
    }

    public record VerifyingAuthenticationProofForTransfer() implements KeycloakTransfertRestrictedAuthenticationNotification
    {
        public static VerifyingAuthenticationProofForTransfer of() {
            return new VerifyingAuthenticationProofForTransfer();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakTransfertRestrictedAuthenticationNotificationEnum.VERIFYING_SIGNATURE;
        }
    }

    public record TransferAuthenticationSuccess() implements KeycloakTransfertRestrictedAuthenticationNotification
    {
        public static TransferAuthenticationSuccess of() {
            return new TransferAuthenticationSuccess();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakTransfertRestrictedAuthenticationNotificationEnum.SUCCESS;
        }
    }

    public record TransferAuthenticationFailure(KeycloakUtils.RfcError rfcError) implements KeycloakTransfertRestrictedAuthenticationNotification
    {
        public static TransferAuthenticationFailure of(KeycloakUtils.RfcError rfcError) {
            return new TransferAuthenticationFailure(rfcError);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakTransfertRestrictedAuthenticationNotificationEnum.FAILURE;
        }
    }

    public static sealed interface KeycloakTransfertRestrictedAuthenticationNotification
    extends NotificationType
    permits BuildingAuthenticationUrl, WaitingForTransferUserAuthentication, VerifyingAuthenticationProofForTransfer, TransferAuthenticationSuccess, TransferAuthenticationFailure {
    }

    public static enum KeycloakTransfertRestrictedAuthenticationNotificationEnum implements NotificationType.NotificationEnumType
    {
        BUILDING_AUTHENTICATION_URL,
        WAITING_FOR_AUTHENTICATION_RESULT,
        VERIFYING_SIGNATURE,
        SUCCESS,
        FAILURE;

    }
}

