/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol;

import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.AbstractProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocolNC;
import io.olvid.windows.messenger.keycloak.protocol.NotificationDelegate;
import io.olvid.windows.messenger.keycloak.protocol.StepsExecutor;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.authentication.steps.BuildAuthenticationURLStep;
import io.olvid.windows.messenger.keycloak.protocol.authentication.steps.DiscoverStep;
import io.olvid.windows.messenger.keycloak.protocol.authentication.steps.GetAccessTokenStep;
import io.olvid.windows.messenger.keycloak.protocol.authentication.steps.HandleRedirectStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import java.util.Optional;

public final class AuthenticationProtocol
extends AbstractProtocol<AuthenticationProtocolContext, KeycloakUtils.RfcError>
implements KeycloakProtocol,
NotificationDelegate<AuthenticationProtocolContext, KeycloakUtils.RfcError> {
    private AuthenticationProtocol(String serverUrl, String clientId, Optional<String> clientSecret, KeycloakManager.RedirectType redirectType, Optional<BytesKey> bytesKeyOpt, Either<KeycloakProtocolNC, NotificationListener<KeycloakAuthenticationNotification>> centerOrListener) {
        this.context = AuthenticationProtocolContext.of(serverUrl, clientId, clientSecret, redirectType, bytesKeyOpt, centerOrListener);
        this.stepsExecutor = new StepsExecutor<AuthenticationProtocolContext, KeycloakUtils.RfcError>((AuthenticationProtocolContext)this.context, new DiscoverStep(), this);
    }

    public static AuthenticationProtocol of(String serverUrl, String clientId, Optional<String> clientSecret, KeycloakManager.RedirectType redirectType, Optional<BytesKey> bytesKeyOpt, Either<KeycloakProtocolNC, NotificationListener<KeycloakAuthenticationNotification>> notificationCenter) {
        return new AuthenticationProtocol(serverUrl, clientId, clientSecret, redirectType, bytesKeyOpt, notificationCenter);
    }

    @Override
    public void notifyProtocolStarted() {
        ((AuthenticationProtocolContext)this.context).fireDiscoveringStateNotification();
    }

    @Override
    public void postStepNotification(AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> step) {
        if (step instanceof BuildAuthenticationURLStep) {
            ((AuthenticationProtocolContext)this.context).fireWaitingForRedirectNotification(((AuthenticationProtocolContext)this.context).getAuthenticationUrl());
        } else if (step instanceof HandleRedirectStep) {
            ((AuthenticationProtocolContext)this.context).fireWaitingForAccessToken();
        } else if (step instanceof GetAccessTokenStep) {
            ((AuthenticationProtocolContext)this.context).fireAuthenticationSuccess();
        }
    }

    @Override
    public void stepFailed(AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> step) {
        ((AuthenticationProtocolContext)this.context).fireAuthenticationFailedNotification(step.getFailReason());
    }

    public record AuthenticationProtocolFailed(KeycloakUtils.RfcError failMessage) implements KeycloakAuthenticationNotification
    {
        public static AuthenticationProtocolFailed of(KeycloakUtils.RfcError failedStep) {
            return new AuthenticationProtocolFailed(failedStep);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakAuthenticationProtocolNotification.AUTHENTICATION_FAILED;
        }
    }

    public record AuthenticationSuccessNotification(Optional<String> serializedAuthState) implements KeycloakAuthenticationNotification
    {
        public static AuthenticationSuccessNotification of(Optional<String> serializedAuthState) {
            return new AuthenticationSuccessNotification(serializedAuthState);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakAuthenticationProtocolNotification.AUTHENTICATION_SUCCEED;
        }
    }

    public record WaitingForAccessTokenNotification() implements KeycloakAuthenticationNotification
    {
        public static WaitingForAccessTokenNotification of() {
            return new WaitingForAccessTokenNotification();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakAuthenticationProtocolNotification.WAITING_FOR_ACCESS_TOKEN;
        }
    }

    public record WaitingForAuthorizationCodeNotification(String authenticationUrl) implements KeycloakAuthenticationNotification
    {
        public static WaitingForAuthorizationCodeNotification of(String authenticationUrl) {
            return new WaitingForAuthorizationCodeNotification(authenticationUrl);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakAuthenticationProtocolNotification.WAITING_FOR_AUTHORIZATION_CODE;
        }
    }

    public record DiscoveringNotification() implements KeycloakAuthenticationNotification
    {
        public static DiscoveringNotification of() {
            return new DiscoveringNotification();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakAuthenticationProtocolNotification.DISCOVERING;
        }
    }

    public static sealed interface KeycloakAuthenticationNotification
    extends NotificationType
    permits DiscoveringNotification, WaitingForAuthorizationCodeNotification, WaitingForAccessTokenNotification, AuthenticationSuccessNotification, AuthenticationProtocolFailed {
    }

    public static enum KeycloakAuthenticationProtocolNotification implements NotificationType.NotificationEnumType
    {
        DISCOVERING,
        WAITING_FOR_AUTHORIZATION_CODE,
        WAITING_FOR_ACCESS_TOKEN,
        AUTHENTICATION_SUCCEED,
        AUTHENTICATION_FAILED;

    }
}

