/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.ObvBase64;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.ContactApi;
import io.olvid.windows.messenger.fx.misc.HttpClientHelper;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import io.olvid.windows.messenger.keycloak.pojos.AuthenticationProofResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.ConfigurationPojo;
import io.olvid.windows.messenger.keycloak.pojos.GetGroupsQueryPojo;
import io.olvid.windows.messenger.keycloak.pojos.GetGroupsResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.GetKeyQueryPojo;
import io.olvid.windows.messenger.keycloak.pojos.GetKeyResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.KeycloakSearchParamsPojo;
import io.olvid.windows.messenger.keycloak.pojos.KeycloakSearchResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.MeQueryJson;
import io.olvid.windows.messenger.keycloak.pojos.MeResponseJson;
import io.olvid.windows.messenger.keycloak.pojos.TokenEndpointResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.TransferProofRequestPojo;
import io.olvid.windows.messenger.keycloak.protocol.ProtocolContext;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;

public class KeycloakUtils {
    private static final BlockingQueue<UnstackTask> blockingQueue = new LinkedBlockingDeque<UnstackTask>();
    public static final String QUERY_PARAMS_BEGIN = "?";
    public static final String AUTHORIZATION_REQ_PROP = "Authorization";
    public static final String AUTHORIZATION_BEARER_VALUE = "Bearer ";
    public static final String RESPONSE_TYPE_PARAM = "response_type";
    public static final String REDIRECT_URI_PARAM = "redirect_uri";
    public static final String CLIENT_ID_PARAM = "client_id";
    public static final String CLIENT_SECRET_PARAM = "client_secret";
    public static final String REFRESH_TOKEN_PARAM = "refresh_token";
    public static final String SCOPE_PARAM = "scope";
    public static final String GRANT_TYPE_PARAM = "grant_type";
    public static final String CODE_CHALLENGE_PARAM = "code_challenge";
    public static final String CODE_VERIFIER_PARAM = "code_verifier";
    public static final String CODE_CHALLENGE_METHOD_PARAM = "code_challenge_method";
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String CODE_CHALLENGE_METHOD_S256_VALUE = "S256";
    public static final String RESPONSE_TYPE_CODE_VALUE = "code";
    public static final String SCOPE_OPENID_VALUE = "openid";
    public static final String SCOPE_OFFLINE_ACCESS_VALUE = "offline_access";
    public static final String GRANT_TYPE_AUTHORIZATION_CODE_VALUE = "authorization_code";
    public static final String GRANT_TYPE_REFRESH_TOKEN_VALUE = "refresh_token";
    public static final String GRANT_TYPE_PASSWORD = "password";
    public static final String URL_CONFIGURATION_HOST = "configuration.olvid.io/";
    public static final String PROTOCOL_PATH = "protocol/openid-connect/";
    public static final String WELL_KNOWN_ENDPOINT = ".well-known/openid-configuration";
    private static final String AUTH_ENDPOINT = "auth";
    public static final String TOKEN_ENDPOINT = "token";
    public static final String KEYCLOAK_REDIRECT_PROTOCOL = "olvid.openid";
    public static String KEYCLOAK_REDIRECT_URL;
    private static String REDIRECT_HOST;
    public static final String ME_ENDPOINT = "olvid-rest/me";
    public static final String PUT_KEY_ENDPOINT = "olvid-rest/putKey";
    public static final String GET_KEY_ENDPOINT = "olvid-rest/getKey";
    public static final String SEARCH_ENDPOINT = "olvid-rest/search";
    public static final String REVOCATION_TEST_ENDPOINT = "olvid-rest/revocationTest";
    public static final String GROUPS_ENDPOINT = "olvid-rest/groups";
    private static final String TRANSFER_PROOF = "olvid-rest/transferProof";
    public static final int RFC_UNKNOWN_ERROR = 0;
    public static final int RFC_INVALID_AUTH_STATE = 1;
    public static final int RFC_AUTHENTICATION_REQUIRED = 2;
    public static final int RFC_NETWORK_ERROR = 3;
    public static final int RFC_BAD_RESPONSE = 4;
    public static final int RFC_INVALID_SIGNATURE = 5;
    public static final int RFC_SERVER_ERROR = 6;
    public static final int RFC_IDENTITY_NOT_MANAGED = 7;
    public static final int RFC_AUTHENTICATION_CANCELLED = 8;
    public static final int RFC_USER_NOT_AUTHENTICATED = 9;
    public static final int RFC_IDENTITY_ALREADY_UPLOADED = 10;
    public static final int RFC_IDENTITY_REVOKED = 11;
    public static final int ERROR_CODE_INTERNAL_ERROR = 1;
    public static final int ERROR_CODE_PERMISSION_DENIED = 2;
    public static final int ERROR_CODE_INVALID_REQUEST = 3;
    public static final int ERROR_CODE_IDENTITY_ALREADY_UPLOADED = 4;
    public static final int ERROR_CODE_IDENTITY_WAS_REVOKED = 6;
    static final int CODE_VERIFIER_LENGTH = 64;
    public static final String PROMPT = "prompt";
    public static final String LOGIN = "login consent";
    private static final String STATE_PARAM = "state";
    private static final Thread unstackThread;
    public static final Pattern CONFIGURATION_PATTERN;
    public static final Pattern KEYCLOAK_REDIRECT_PATTERN;
    private static final ObjectMapper jsonObjectMapper;
    static final String CODE_PARAM = "code";

    public static boolean isConfigurationUri(String uri) {
        Matcher matcher = CONFIGURATION_PATTERN.matcher(uri);
        return matcher.find();
    }

    public static boolean isRedirectUri(String uri) {
        Matcher matcher = KEYCLOAK_REDIRECT_PATTERN.matcher(uri);
        return matcher.find();
    }

    public static ConfigurationPojo getConfigurationFromUri(String uri) {
        try {
            Matcher matcher = CONFIGURATION_PATTERN.matcher(uri);
            if (matcher.find()) {
                return (ConfigurationPojo)EngineWrapper.getJsonObjectMapper().readValue(ObvBase64.decode((String)matcher.group(2)), ConfigurationPojo.class);
            }
        }
        catch (Exception e) {
            AppLogger.e("KeycloakUtils::getConfigurationFromUri Something went wrong reading configuration ", e);
        }
        return null;
    }

    public static KeycloakCallReturn<String> getStringCodeFromRedirectUrl(String url) {
        AppLogger.d("KeycloakUtils::getCodeFromRedirectUrl url = " + url);
        try {
            List params = new URIBuilder(new URI(url), StandardCharsets.UTF_8).getQueryParams();
            for (NameValuePair param : params) {
                if (!"code".equals(param.getName())) continue;
                return new KeycloakCallReturn<String>(Either.left(param.getValue()));
            }
        }
        catch (URISyntaxException uriSyntaxException) {
            AppLogger.e("KeycloakUtils::getCodeFromRedirectUrl error parsing redirect uri", uriSyntaxException);
        }
        return new KeycloakCallReturn<String>(Either.right(RfcError.RFC_INTERNAL_ERROR));
    }

    public static KeycloakCallReturn<KeycloakManager.RedirectType> getRedirectTypeFromUrl(String url) {
        AppLogger.d("KeycloakUtils::getCodeFromRedirectUrl url = " + url);
        try {
            List params = new URIBuilder(new URI(url), StandardCharsets.UTF_8).getQueryParams();
            for (NameValuePair param : params) {
                if (!STATE_PARAM.equals(param.getName())) continue;
                return new KeycloakCallReturn<KeycloakManager.RedirectType>(Either.left(KeycloakManager.RedirectType.valueOf(param.getValue())));
            }
        }
        catch (URISyntaxException uriSyntaxException) {
            AppLogger.e("KeycloakUtils::getCodeFromRedirectUrl error parsing redirect uri", uriSyntaxException);
        }
        return new KeycloakCallReturn<KeycloakManager.RedirectType>(Either.right(RfcError.RFC_INTERNAL_ERROR));
    }

    private static <T> T queuedRequest(Supplier<T> supplier) {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference responseRef = new AtomicReference();
        blockingQueue.add(() -> {
            responseRef.set(supplier.get());
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return (T)responseRef.get();
    }

    public static KeycloakCallReturn<JsonWebKeySet> discoverKeycloakServer(String kcServerUrl) {
        KeycloakCallReturn ret = KeycloakUtils.queuedRequest(() -> {
            AppLogger.d("KeycloakUtils::discoverKeycloakServer Discovering keycloak server at " + kcServerUrl);
            RfcError error = null;
            try (CloseableHttpClient httpClient = HttpClientHelper.getHttpClient();){
                HttpGet httpGet = new HttpGet(kcServerUrl + WELL_KNOWN_ENDPOINT);
                httpGet.addHeader("Content-Type", (Object)"application/json");
                try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);){
                    String responseContent;
                    Map wellKnownJsonResponse;
                    AppLogger.d("KeycloakUtils::d&iscoverKeycloakServer Discovering keycloak response code :" + response.getCode());
                    if (response.getCode() == 200 && (wellKnownJsonResponse = (Map)jsonObjectMapper.readValue(responseContent = EntityUtils.toString((HttpEntity)response.getEntity()), (TypeReference)new TypeReference<Map<String, Object>>(){})).containsKey("jwks_uri")) {
                        KeycloakCallReturn<JsonWebKeySet> keycloakCallReturn = KeycloakUtils.getJkws((String)wellKnownJsonResponse.get("jwks_uri"));
                        return keycloakCallReturn;
                    }
                }
            }
            catch (SocketException | SocketTimeoutException | UnknownHostException | SSLException netException) {
                AppLogger.e("KeycloakUtils::discoverKeycloakServer socket exception ", netException);
                return new KeycloakCallReturn(Either.right(RfcError.RFC_NETWORK_ERROR));
            }
            catch (JsonProcessingException exception) {
                AppLogger.e("KeycloakUtils::discoverKeycloakServer couldn't deserialize token response ", (Exception)((Object)exception));
            }
            catch (IOException exception) {
                AppLogger.e("KeycloakUtils::discoverKeycloakServer couldn't execute request ", exception);
            }
            catch (Exception e) {
                AppLogger.e("KeycloakUtils::discoverKeycloakServer error retrieving fresh token " + String.valueOf(e));
            }
            error = RfcError.RFC_INTERNAL_ERROR;
            return new KeycloakCallReturn(Either.right(error));
        });
        return ret;
    }

    public static KeycloakCallReturn<String> buildAuthRequest(KeycloakManager.RedirectType redirectType, String kcServerUrl, String clientId, String challenger) {
        KeycloakCallReturn<CallSite> keycloakCallReturn;
        AppLogger.d("KeycloakUtils::resquestAuthorizationCode -> server at " + kcServerUrl);
        HttpPost httpPost = new HttpPost(kcServerUrl + "protocol/openid-connect/auth");
        httpPost.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair(RESPONSE_TYPE_PARAM, "code"));
        urlParameters.add(new BasicNameValuePair(CLIENT_ID_PARAM, clientId));
        urlParameters.add(new BasicNameValuePair(REDIRECT_URI_PARAM, KEYCLOAK_REDIRECT_URL));
        urlParameters.add(new BasicNameValuePair(SCOPE_PARAM, SCOPE_OPENID_VALUE));
        urlParameters.add(new BasicNameValuePair(PROMPT, LOGIN));
        urlParameters.add(new BasicNameValuePair(CODE_CHALLENGE_METHOD_PARAM, CODE_CHALLENGE_METHOD_S256_VALUE));
        urlParameters.add(new BasicNameValuePair(CODE_CHALLENGE_PARAM, challenger));
        urlParameters.add(new BasicNameValuePair(STATE_PARAM, redirectType.name()));
        UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(urlParameters, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)httpEntity);
        AppLogger.d(httpPost.getRequestUri());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            httpPost.getEntity().writeTo((OutputStream)baos);
            AppLogger.d(baos.toString(StandardCharsets.UTF_8));
            keycloakCallReturn = new KeycloakCallReturn<CallSite>(Either.left(String.valueOf(httpPost.getUri()) + QUERY_PARAMS_BEGIN + baos.toString(StandardCharsets.UTF_8)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                AppLogger.e("KeycloakUtils::resquestAuthorizationCode couldn't process uri for request of type : " + String.valueOf((Object)redirectType), e);
                return new KeycloakCallReturn<String>(Either.right(RfcError.RFC_INTERNAL_ERROR));
            }
        }
        baos.close();
        return keycloakCallReturn;
    }

    public static KeycloakCallReturn<TokenEndpointResponsePojo> getAccessToken(String kcServerurl, String clientId, String clientSecret, String code, String challenger) {
        KeycloakCallReturn toRet = KeycloakUtils.queuedRequest(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 15[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        return toRet;
    }

    public static ObjectMapper getJsonObjectMapper() {
        return jsonObjectMapper;
    }

    public static Pair<String, String> generateChallenge() {
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        PRNGService prngService = Suite.getDefaultPRNGService((int)0);
        byte[] codeVerifierBytes = prngService.bytes(64);
        String codeVerifier = encoder.encodeToString(codeVerifierBytes);
        byte[] codeChallenge = Suite.getHash((String)"sha-256").digest(codeVerifier.getBytes(StandardCharsets.UTF_8));
        return Pair.of(codeVerifier, encoder.encodeToString(codeChallenge));
    }

    public static KeycloakCallReturn<Pair<String, JsonWebKey>> verifyDetailsSignature(String signature, JsonWebKeySet jwks, JsonWebKey signatureKey) {
        List<JsonWebKey> jsonWebKeys = signatureKey == null ? jwks.getJsonWebKeys() : Collections.singletonList(signatureKey);
        JwksVerificationKeyResolver jwksResolver = new JwksVerificationKeyResolver(jsonWebKeys);
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedAudience(false, new String[0]).setVerificationKeyResolver((VerificationKeyResolver)jwksResolver).build();
        try {
            JwtContext context = jwtConsumer.process(signature);
            JsonWebKey jsonWebKey = new VerificationJwkSelector().select((JsonWebSignature)context.getJoseObjects().get(0), jsonWebKeys);
            return new KeycloakCallReturn<Pair<String, JsonWebKey>>(Either.left(new Pair<String, JsonWebKey>(context.getJwtClaims().getRawJson(), jsonWebKey)));
        }
        catch (InvalidJwtException e) {
            AppLogger.e("KeycloakUtils::verifySignature couldn't verify signature", (Exception)((Object)e));
            return new KeycloakCallReturn<Pair<String, JsonWebKey>>(Either.right(RfcError.RFC_INVALID_DETAILS_SIGNATURE));
        }
        catch (JoseException e) {
            AppLogger.e("KeycloakUtils::verifySignature couldn't select json web key", (Exception)((Object)e));
        }
        catch (Exception e) {
            AppLogger.e("KeycloakUtils::verifySignature general error", e);
        }
        return new KeycloakCallReturn<Pair<String, JsonWebKey>>(Either.right(RfcError.RFC_INTERNAL_ERROR));
    }

    public static KeycloakCallReturn<MeResponseJson> getOwnDetails(byte[] ownedIdentityBytes, String keycloakServerUrl, String clientSecret, String clientId, Long latestRevocationListTimestamp, SimpleAuthState simpleAuthState) {
        int retCode;
        AppLogger.d("KeycloakUtils::getOwnDetails()");
        if (ownedIdentityBytes != null && 200 != (retCode = KeycloakUtils.getFreshTokenIfNeeded(ownedIdentityBytes, keycloakServerUrl, clientId, clientSecret, simpleAuthState))) {
            return new KeycloakCallReturn<MeResponseJson>(Either.right(RfcError.RFC_AUTHENTICATION_REQUIRED));
        }
        try {
            String dataToSend = latestRevocationListTimestamp == null ? null : jsonObjectMapper.writeValueAsString((Object)new MeQueryJson(latestRevocationListTimestamp));
            KeycloakCallReturn<byte[]> codeWithResponse = KeycloakUtils.olvidApiRequest(keycloakServerUrl, ME_ENDPOINT, simpleAuthState.accessToken, dataToSend);
            if (codeWithResponse.isSuccess()) {
                MeResponseJson meResponse = (MeResponseJson)jsonObjectMapper.readValue(codeWithResponse.getResult(), MeResponseJson.class);
                return new KeycloakCallReturn<MeResponseJson>(Either.left(meResponse));
            }
            return new KeycloakCallReturn<MeResponseJson>(Either.right(codeWithResponse.getError()));
        }
        catch (IOException ioException) {
            AppLogger.e("KeycloakUtils::getOwnDetails couldn't deserialize me query json... ", ioException);
            return new KeycloakCallReturn<MeResponseJson>(Either.right(RfcError.RFC_INTERNAL_ERROR));
        }
    }

    static KeycloakCallReturn<KeycloakSearchResponsePojo> search(byte[] ownedIdentityBytes, String keycloakServerUrl, SimpleAuthState simpleAuthState, String clientId, String clientSecret, String searchQuery) {
        AppLogger.d("KeycloakUtils::search()");
        int retCode = KeycloakUtils.getFreshTokenIfNeeded(ownedIdentityBytes, keycloakServerUrl, clientId, clientSecret, simpleAuthState);
        if (200 != retCode) {
            return new KeycloakCallReturn<KeycloakSearchResponsePojo>(Either.right(RfcError.RFC_AUTHENTICATION_REQUIRED));
        }
        try {
            KeycloakSearchParamsPojo params = new KeycloakSearchParamsPojo();
            params.filter = searchQuery == null ? null : searchQuery.trim().split("\\s+");
            KeycloakCallReturn<byte[]> codeWithResponse = KeycloakUtils.olvidApiRequest(keycloakServerUrl, SEARCH_ENDPOINT, simpleAuthState.getAccessToken(), jsonObjectMapper.writeValueAsString((Object)params));
            if (codeWithResponse.isSuccess()) {
                KeycloakSearchResponsePojo toRet = (KeycloakSearchResponsePojo)jsonObjectMapper.readValue(codeWithResponse.getResult(), KeycloakSearchResponsePojo.class);
                return new KeycloakCallReturn<KeycloakSearchResponsePojo>(Either.left(toRet));
            }
            return new KeycloakCallReturn<KeycloakSearchResponsePojo>(Either.right(codeWithResponse.getError()));
        }
        catch (IOException ioException) {
            AppLogger.e("KeycloakUtils::search couldn't IO error on http connection... ", ioException);
            return new KeycloakCallReturn<KeycloakSearchResponsePojo>(Either.right(RfcError.RFC_INTERNAL_ERROR));
        }
    }

    static KeycloakCallReturn<Integer> addContact(String keycloakServerUrl, SimpleAuthState authState, JsonWebKeySet jwks, JsonWebKey signatureKey, byte[] bytesOwnedIdentity, String contactUserId, byte[] bytesContactIdentity) {
        RfcError ret;
        AppLogger.d("KeycloakUtils::addContact Retrieving signed contact details");
        try {
            GetKeyResponsePojo getKeyResponsePojo;
            GetKeyQueryPojo getKeyQueryPojo = new GetKeyQueryPojo();
            getKeyQueryPojo.setUserId(contactUserId);
            KeycloakCallReturn<byte[]> codesWithResponse = KeycloakUtils.olvidApiRequest(keycloakServerUrl, GET_KEY_ENDPOINT, authState.accessToken, jsonObjectMapper.writeValueAsString((Object)getKeyQueryPojo));
            if (codesWithResponse.isSuccess() && (getKeyResponsePojo = (GetKeyResponsePojo)jsonObjectMapper.readValue(codesWithResponse.getResult(), GetKeyResponsePojo.class)) != null) {
                KeycloakCallReturn<Pair<String, JsonWebKey>> detailsJsonStringAndSignatureKey = KeycloakUtils.verifyDetailsSignature(getKeyResponsePojo.getSignature(), jwks, signatureKey);
                if (detailsJsonStringAndSignatureKey.isSuccess()) {
                    JsonKeycloakUserDetails userDetails = (JsonKeycloakUserDetails)jsonObjectMapper.readValue(detailsJsonStringAndSignatureKey.getResult().getFirst(), JsonKeycloakUserDetails.class);
                    if (Arrays.equals(userDetails.getIdentity(), bytesContactIdentity)) {
                        EngineWrapper.getInstance().addKeycloakContact(bytesOwnedIdentity, bytesContactIdentity, getKeyResponsePojo.getSignature());
                        return new KeycloakCallReturn<Integer>(Either.left(0));
                    }
                } else {
                    KeycloakCallReturn<Pair<String, JsonWebKey>> detailsJsonString = KeycloakUtils.verifyDetailsSignature(getKeyResponsePojo.getSignature(), jwks, null);
                    if (detailsJsonString.isSuccess()) {
                        KeycloakManager.getInstance().forceSyncManagedIdentity(bytesOwnedIdentity);
                    }
                }
            }
            ret = RfcError.RFC_INVALID_DETAILS_SIGNATURE;
        }
        catch (IOException e) {
            AppLogger.e("KeycloakUtils::addContact couldn't IO error on http connection... ", e);
            ret = RfcError.RFC_NETWORK_ERROR;
        }
        catch (Exception e) {
            AppLogger.e("KeycloakUtils::addContact unknown error...", e);
            ret = RfcError.RFC_INTERNAL_ERROR;
        }
        return new KeycloakCallReturn<Integer>(Either.right(ret));
    }

    static void addContactWithEngineSignedDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        try {
            Optional<String> signedDetails = ContactApi.getContactSignedDetails(bytesOwnedIdentity, bytesContactIdentity);
            if (signedDetails.isEmpty()) {
                AppLogger.e("KeycloakManager empty signed details ");
                return;
            }
            EngineWrapper.getInstance().addKeycloakContact(bytesOwnedIdentity, bytesContactIdentity, signedDetails.get());
        }
        catch (Exception e) {
            AppLogger.e("KeycloakManager::addContact couldn't call engine", e);
        }
    }

    public static KeycloakCallReturn<Integer> uploadOwnIdentity(String keycloakServerUrl, SimpleAuthState simpleAuthState, String clientSecret, String clientId, byte[] bytesOwnedIdentity) {
        AppLogger.d("KeycloakUtils::uploadOwnIdentity Uploading Olvid ID to keycloak");
        try {
            HashMap<String, byte[]> input = new HashMap<String, byte[]>();
            input.put("identity", bytesOwnedIdentity);
            int retCode = KeycloakUtils.getFreshTokenIfNeeded(bytesOwnedIdentity, keycloakServerUrl, clientId, clientSecret, simpleAuthState);
            if (200 != retCode) {
                return new KeycloakCallReturn<Integer>(Either.right(RfcError.RFC_AUTHENTICATION_REQUIRED));
            }
            KeycloakCallReturn<byte[]> codeWithResponse = KeycloakUtils.olvidApiRequest(keycloakServerUrl, PUT_KEY_ENDPOINT, simpleAuthState.accessToken, jsonObjectMapper.writeValueAsString(input));
            if (codeWithResponse.isSuccess()) {
                return new KeycloakCallReturn<Integer>(Either.left(0));
            }
            return new KeycloakCallReturn<Integer>(Either.right(codeWithResponse.getError()));
        }
        catch (JsonProcessingException e) {
            AppLogger.e("KeycloakUtils::uploadOwnIdentity json processing error ... ", (Exception)((Object)e));
            return new KeycloakCallReturn<Integer>(Either.right(RfcError.RFC_INTERNAL_ERROR));
        }
    }

    public static KeycloakCallReturn<GetGroupsResponsePojo> getGroups(String keycloakServerUrl, SimpleAuthState simpleAuthState, String clientSecret, String clientId, byte[] bytesOwnedIdentity, Long latestGetGroupsTimestamp) {
        AppLogger.d("KeycloakUtils::getGroups: Fetching keycloak groups");
        GetGroupsQueryPojo request = new GetGroupsQueryPojo(latestGetGroupsTimestamp);
        int retCode = KeycloakUtils.getFreshTokenIfNeeded(bytesOwnedIdentity, keycloakServerUrl, clientId, clientSecret, simpleAuthState);
        if (200 != retCode) {
            return new KeycloakCallReturn<GetGroupsResponsePojo>(Either.right(RfcError.RFC_AUTHENTICATION_REQUIRED));
        }
        try {
            KeycloakCallReturn<byte[]> codeWithResponse = KeycloakUtils.olvidApiRequest(keycloakServerUrl, GROUPS_ENDPOINT, simpleAuthState.accessToken, jsonObjectMapper.writeValueAsString((Object)request));
            if (codeWithResponse.isSuccess()) {
                GetGroupsResponsePojo getGroupsResponsePojo = (GetGroupsResponsePojo)KeycloakUtils.getJsonObjectMapper().readValue(codeWithResponse.getResult(), GetGroupsResponsePojo.class);
                return new KeycloakCallReturn<GetGroupsResponsePojo>(Either.left(getGroupsResponsePojo));
            }
            new KeycloakCallReturn(Either.right(codeWithResponse.getError()));
        }
        catch (JsonProcessingException e) {
            AppLogger.e("KeycloakUtils::getGroups cannot serialize json request ", (Exception)((Object)e));
        }
        catch (IOException e) {
            AppLogger.e("KeycloakUtils::getGroups cannot deserialize server response ", e);
        }
        return new KeycloakCallReturn<GetGroupsResponsePojo>(Either.right(RfcError.RFC_INTERNAL_ERROR));
    }

    static KeycloakCallReturn<Boolean> selfRevocationTest(String keycloakServerUrl, String selfRevocationTestNonce) {
        Logger.d((String)"Checking keycloak for self revocation");
        try {
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("nonce", selfRevocationTestNonce);
            KeycloakCallReturn<byte[]> codeWithResponse = KeycloakUtils.olvidApiRequest(keycloakServerUrl, REVOCATION_TEST_ENDPOINT, null, jsonObjectMapper.writeValueAsString(input));
            if (codeWithResponse.isSuccess()) {
                return new KeycloakCallReturn<Boolean>(Either.left(codeWithResponse.getResult().length == 1 && codeWithResponse.getResult()[0] == 1));
            }
            return new KeycloakCallReturn<Boolean>(Either.right(codeWithResponse.getError()));
        }
        catch (JsonProcessingException e) {
            AppLogger.e("KeycloakUtils::selfRevocationTest Couldn't deserialize return ...", (Exception)((Object)e));
            return new KeycloakCallReturn<Boolean>(Either.right(RfcError.RFC_INTERNAL_ERROR));
        }
    }

    /*
     * Exception decompiling
     */
    private static KeycloakCallReturn<JsonWebKeySet> getJkws(String jwksUri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static KeycloakCallReturn<AuthenticationProofResponsePojo> getAuthenticationProof(String kcServerUrl, String sas, String sessionNumber, String accessToken) {
        AppLogger.d("KeycloakUtils::getAuthenticationProof Fetching authentication proof");
        try {
            TransferProofRequestPojo request = new TransferProofRequestPojo(sessionNumber, sas);
            KeycloakCallReturn<byte[]> response = KeycloakUtils.olvidApiRequest(kcServerUrl, TRANSFER_PROOF, accessToken, jsonObjectMapper.writeValueAsString((Object)request));
            if (response.isSuccess()) {
                AuthenticationProofResponsePojo output = (AuthenticationProofResponsePojo)jsonObjectMapper.readValue(response.getResult(), AuthenticationProofResponsePojo.class);
                return new KeycloakCallReturn<AuthenticationProofResponsePojo>(Either.left(output));
            }
            return new KeycloakCallReturn<AuthenticationProofResponsePojo>(Either.right(response.getError()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            AppLogger.e("KeycloakUtils::getAuthenticationProof couldn't serialize request ", (Exception)((Object)jsonProcessingException));
            return new KeycloakCallReturn<AuthenticationProofResponsePojo>(Either.right(RfcError.RFC_INTERNAL_ERROR));
        }
        catch (IOException e) {
            AppLogger.e("KeycloakUtils::getAuthenticationProof couldn't deserialize response : ", e);
            return new KeycloakCallReturn<AuthenticationProofResponsePojo>(Either.right(RfcError.RFC_INTERNAL_ERROR));
        }
    }

    private static KeycloakCallReturn<byte[]> olvidApiRequest(String keycloakServer, String path, String accessToken, String jsonToSend) {
        KeycloakCallReturn toRet = KeycloakUtils.queuedRequest(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 4[TRYBLOCK]], but top level block is 26[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        return toRet;
    }

    private static Pair<Integer, TokenEndpointResponsePojo> refreshToken(String kcServerUrl, String refreshToken, String clientId, String clientSecret) {
        Pair toRet = KeycloakUtils.queuedRequest(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        return toRet;
    }

    private static int getFreshTokenIfNeeded(byte[] ownedIdentityBytes, String kcServerUrl, String clientId, String clientSecret, SimpleAuthState simpleAuthState) {
        if (simpleAuthState == null) {
            return 2;
        }
        if (!simpleAuthState.isAccessTokenValid()) {
            Pair<Integer, TokenEndpointResponsePojo> codeWithResponse = KeycloakUtils.refreshToken(kcServerUrl, simpleAuthState.refreshToken, clientId, clientSecret);
            if (codeWithResponse.getFirst().equals(200)) {
                simpleAuthState.setAccessToken(codeWithResponse.getSecond().getAccessToken());
                simpleAuthState.setRefreshToken(codeWithResponse.getSecond().getRefreshToken());
                simpleAuthState.setAccessTokenExpirationTimestamp(System.currentTimeMillis() + (long)codeWithResponse.getSecond().getExpiresIn() * 1000L);
                if (ownedIdentityBytes != null) {
                    try {
                        EngineWrapper.getInstance().saveKeycloakAuthState(ownedIdentityBytes, jsonObjectMapper.writeValueAsString((Object)simpleAuthState));
                    }
                    catch (JsonProcessingException e) {
                        AppLogger.e("KeycloakUtils::getFreshTokenIfNeeded Couldn't serialize auth state...", (Exception)((Object)e));
                    }
                    catch (Exception e) {
                        AppLogger.e("KeycloakUtils::getFreshTokenIfNeeded Couldn't save new auth state in engine...");
                    }
                }
            } else {
                AppLogger.e("KeycloakUtils::getFreshTokenIfNeeded() Couldn't refresh token cancelling operation....");
                AppLogger.e("KeycloakUtils::getFreshTokenIfNeeded() error code --> " + String.valueOf(codeWithResponse.getFirst()));
            }
            return codeWithResponse.getFirst();
        }
        return 200;
    }

    public static void stopThread() {
        blockingQueue.add(new UnstackTask(){

            @Override
            public void run() {
            }

            @Override
            public boolean isKillPill() {
                return true;
            }
        });
    }

    static {
        if (AppRuntimeHelper.isDevMode) {
            REDIRECT_HOST = "openid-redirect.dev.olvid.io/";
            KEYCLOAK_REDIRECT_URL = "https://openid-redirect.dev.olvid.io/";
        } else {
            REDIRECT_HOST = "openid-redirect.olvid.io/";
            KEYCLOAK_REDIRECT_URL = "https://openid-redirect.olvid.io/";
        }
        Runnable task = () -> {
            boolean isAlive = true;
            while (isAlive && !Thread.currentThread().isInterrupted()) {
                try {
                    UnstackTask httpCall = blockingQueue.take();
                    if (httpCall.isKillPill()) {
                        isAlive = false;
                        continue;
                    }
                    httpCall.run();
                }
                catch (InterruptedException e) {
                    AppLogger.w("The unstacking Keycloak request thread is done");
                }
            }
        };
        unstackThread = new Thread(task);
        unstackThread.start();
        CONFIGURATION_PATTERN = Pattern.compile("(https|olvid)" + Pattern.quote("://configuration.olvid.io/") + "#([-_a-zA-Z0-9]+)");
        KEYCLOAK_REDIRECT_PATTERN = Pattern.compile("(olvid.openid|https)" + Pattern.quote("://" + REDIRECT_HOST) + "([-_a-zA-Z0-9&?]*)");
        jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.writerWithDefaultPrettyPrinter();
    }

    public static enum RfcError implements ProtocolContext.FailReason
    {
        RFC_INTERNAL_ERROR,
        RFC_BAD_REDIRECT_URL,
        RFC_INVALID_AUTH_STATE,
        RFC_AUTHENTICATION_REQUIRED,
        RFC_NETWORK_ERROR,
        RFC_BAD_RESPONSE,
        RFC_SERVER_ERROR,
        RFC_INVALID_DETAILS_SIGNATURE,
        RFC_IDENTITY_ALREADY_UPLOADED,
        RFC_IDENTITY_REVOKED,
        RFC_IDENTITY_NOT_MANAGED,
        RFC_INTTERUPTED;

    }

    static interface UnstackTask
    extends Runnable {
        default public boolean isKillPill() {
            return false;
        }
    }

    private static class OlvidApiRequestResponseValidationException
    extends JsonProcessingException {
        protected OlvidApiRequestResponseValidationException() {
            super("KeycloakUtils::olvidApiRequest : Validation exception");
        }
    }
}

