/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak;

import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;

public class KeycloakManagerState {
    final byte[] bytesOwnedIdentity;
    JsonIdentityDetails identityDetails;
    Long ownDetailsSignatureTimestamp;
    final String serverUrl;
    final String clientId;
    final String clientSecret;
    JsonWebKeySet jwks;
    JsonWebKey signatureKey;
    long lastSynchronization;
    boolean autoRevokeOnNextSync;
    long latestRevocationListTimestamp;
    long latestGetGroupsTimestamp;
    SimpleAuthState simpleAuthState;
    String ownApiKey;
    boolean transferRestricted;

    public JsonIdentityDetails getIdentityDetails() {
        return this.identityDetails;
    }

    public Long getOwnDetailsSignatureTimestamp() {
        return this.ownDetailsSignatureTimestamp;
    }

    public JsonWebKeySet getJwks() {
        return this.jwks;
    }

    public JsonWebKey getSignatureKey() {
        return this.signatureKey;
    }

    public long getLastSynchronization() {
        return this.lastSynchronization;
    }

    public boolean isAutoRevokeOnNextSync() {
        return this.autoRevokeOnNextSync;
    }

    public long getLatestRevocationListTimestamp() {
        return this.latestRevocationListTimestamp;
    }

    public SimpleAuthState getSimpleAuthState() {
        return this.simpleAuthState;
    }

    public KeycloakManagerState(ObvIdentity obvIdentity, String serverUrl, String clientId, String clientSecret, SimpleAuthState simpleAuthState, JsonWebKeySet jwks, JsonWebKey signatureKey, String ownApiKey, long latestRevocationListTimestamp, boolean transferRestricted) {
        this.bytesOwnedIdentity = obvIdentity.getBytesIdentity();
        this.identityDetails = obvIdentity.getIdentityDetails();
        this.transferRestricted = transferRestricted;
        if (this.identityDetails.getSignedUserDetails() != null) {
            try {
                JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
                JwtContext context = jwtConsumer.process(this.identityDetails.getSignedUserDetails());
                JsonKeycloakUserDetails jsonKeycloakUserDetails = (JsonKeycloakUserDetails)KeycloakUtils.getJsonObjectMapper().readValue(context.getJwtClaims().getRawJson(), JsonKeycloakUserDetails.class);
                this.ownDetailsSignatureTimestamp = jsonKeycloakUserDetails.getTimestamp();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.ownDetailsSignatureTimestamp = null;
            }
        } else {
            this.ownDetailsSignatureTimestamp = null;
        }
        this.serverUrl = serverUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.simpleAuthState = simpleAuthState;
        this.jwks = jwks;
        this.signatureKey = signatureKey;
        this.lastSynchronization = 0L;
        this.autoRevokeOnNextSync = false;
        this.latestRevocationListTimestamp = latestRevocationListTimestamp;
        this.latestGetGroupsTimestamp = 0L;
        this.ownApiKey = ownApiKey;
    }
}

