/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.update;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.LatestVersionDownloadConfirmationModalController;
import io.olvid.windows.messenger.fx.settings.SettingsModalModel;
import io.olvid.windows.messenger.fx.settings.components.ButtonSettingItemView;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class UpdateSettingController
extends BaseViewController {
    public VBox root = new VBox();
    public final HBox header = new HBox();
    public final Region headerVSep = new Region();
    public final ButtonSettingItemView versionSettingItem;
    private final Label badge = new Label();
    private final SimpleStringProperty titleProperty;
    private final SimpleStringProperty subTitleProperty;

    public UpdateSettingController(SettingsModalModel model, SimpleStringProperty titleProperty, SimpleStringProperty subTitleProperty) {
        this.titleProperty = titleProperty;
        this.subTitleProperty = subTitleProperty;
        this.headerVSep.setMaxHeight(1.0);
        this.headerVSep.setPrefHeight(1.0);
        VBox.setMargin((Node)this.headerVSep, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        this.headerVSep.getStyleClass().add((Object)"separator");
        this.versionSettingItem = new ButtonSettingItemView();
        this.versionSettingItem.settingLabel.textProperty().bind((ObservableValue)model.currentAppVersionProperty);
        this.badge.getStyleClass().add((Object)"notification-number");
        this.badge.setText("1");
        this.badge.managedProperty().bind((ObservableValue)this.badge.visibleProperty());
        this.badge.visibleProperty().bind((ObservableValue)model.updateNeededProperty);
        this.versionSettingItem.getChildren().add(this.versionSettingItem.getChildren().size() - 1, (Object)this.badge);
        this.versionSettingItem.chevronContainer.visibleProperty().bind((ObservableValue)model.updateNeededProperty);
        this.versionSettingItem.chevronContainer.managedProperty().bind((ObservableValue)this.versionSettingItem.chevronContainer.visibleProperty());
        this.versionSettingItem.setOnMouseClicked(event -> {
            if (model.updateNeededProperty.get()) {
                NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new LatestVersionDownloadConfirmationModalController(model.outdatedVersionProperty.get()), false));
            }
        });
        this.root.setSpacing(20.0);
        this.root.setPadding(new Insets(0.0, 24.0, 0.0, 24.0));
        this.root.getChildren().addAll((Object[])new Node[]{this.headerVSep, this.versionSettingItem});
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.titleProperty.set(ViewControllerHelper.getString("update_availability_setting_item_label"));
        this.subTitleProperty.set("");
    }

    @Override
    public void onLayoutDetached() {
    }
}

