/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.misc;

import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.components.ComboSettingItemView;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import java.util.Arrays;

public enum EnterToSendOption implements ComboSettingItemView.ComboItem
{
    ENTER(0),
    SHIFT_ENTER(1),
    CTRL_ENTER(2);

    public final int value;

    private EnterToSendOption(int value) {
        this.value = value;
    }

    private String localizedLabelKey() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "setting.enter_to_send.option.enter";
            case 1 -> "setting.enter_to_send.option.shift_enter";
            case 2 -> "setting.enter_to_send.option.ctrl_enter";
        };
    }

    @Override
    public String title() {
        return ViewControllerHelper.getString(this.localizedLabelKey());
    }

    @Override
    public void update() {
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.ENTER_TO_SEND, Integer.toString(this.value));
    }

    public static EnterToSendOption of(int value) {
        return Arrays.stream(EnterToSendOption.values()).filter(t -> t.value == value).findFirst().orElse(ENTER);
    }
}

