/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.misc;

import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.components.ComboSettingItemView;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import java.util.Arrays;

public enum AutomaticAttachmentSizeDlThreshold implements ComboSettingItemView.ComboItem
{
    NEVER(0),
    ONE_MO(1000000),
    FIVE_MO(5000000),
    TEN_MO(10000000),
    FIFTY_MO(50000000),
    ALWAYS(-1);

    public final int value;

    private AutomaticAttachmentSizeDlThreshold(int value) {
        this.value = value;
    }

    private String localizedLabelKey() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "autodownload_size_disabled_setting_label";
            case 1 -> "autodownload_size_1M_setting_label";
            case 2 -> "autodownload_size_5M_setting_label";
            case 3 -> "autodownload_size_10M_setting_label";
            case 4 -> "autodownload_size_50M_setting_label";
            case 5 -> "autodownload_size_always_setting_label";
        };
    }

    public String getLabel() {
        return ViewControllerHelper.getString(this.localizedLabelKey());
    }

    public static AutomaticAttachmentSizeDlThreshold of(int value) {
        return Arrays.stream(AutomaticAttachmentSizeDlThreshold.values()).filter(t -> t.value == value).findFirst().orElseThrow();
    }

    @Override
    public String title() {
        return this.getLabel();
    }

    @Override
    public void update() {
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.AUTOMATIC_ATTACHMENT_DOWNLOAD_SIZE_SETTING_KEY, Integer.toString(this.value));
    }
}

