/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.general;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.fx.settings.misc.AutomaticAttachmentSizeDlThreshold;
import io.olvid.windows.messenger.fx.settings.misc.EnterToSendOption;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;

public class GeneralSettingsViewModel {
    private final AppLogger logger = new AppLogger(GeneralSettingsViewModel.class);
    public final BooleanProperty notificationCenterAvailableProp = new SimpleBooleanProperty();
    public final BooleanProperty launchOnStartProp = new SimpleBooleanProperty();
    public final BooleanProperty launchInBackgroundProp = new SimpleBooleanProperty();
    public final BooleanProperty sendReadReceiptProp = new SimpleBooleanProperty();
    public final ObjectProperty<AutomaticAttachmentSizeDlThreshold> automaticAttachmentSizeDlThreshold = new SimpleObjectProperty();
    public final ObjectProperty<EnterToSendOption> enterToSendOptionProp = new SimpleObjectProperty((Object)EnterToSendOption.ENTER);
    private final LiveData<List<ApplicationSetting>> settingsLiveData = LiveDataFactory.buildDbLiveDataList(ApplicationSetting.class, () -> DbManager.getInstance().getApplicationSettingsDao().getAll());
    private final LiveDataListener<List<ApplicationSetting>> appSettingListener = this::onAppSettingsChanged;

    public GeneralSettingsViewModel() {
        this.notificationCenterAvailableProp.set(AppRuntimeHelper.isWindows());
        switch (AppRuntimeHelper.getStartupMode()) {
            case NONE: {
                this.launchOnStartProp.set(false);
                this.launchInBackgroundProp.set(false);
                break;
            }
            case FOREGROUND: {
                this.launchOnStartProp.set(true);
                this.launchInBackgroundProp.set(false);
                break;
            }
            case BACKGROUND: {
                this.launchOnStartProp.set(true);
                this.launchInBackgroundProp.set(true);
            }
        }
        this.sendReadReceiptProp.set(ApplicationSettingsDatabaseCache.getInstance().getAsBoolean(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY));
        String downloadedSizeStr = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.AUTOMATIC_ATTACHMENT_DOWNLOAD_SIZE_SETTING_KEY);
        if (downloadedSizeStr == null) {
            this.automaticAttachmentSizeDlThreshold.set((Object)AutomaticAttachmentSizeDlThreshold.TEN_MO);
        } else {
            try {
                int v = Integer.parseInt(downloadedSizeStr);
                this.automaticAttachmentSizeDlThreshold.set((Object)AutomaticAttachmentSizeDlThreshold.of(v));
            }
            catch (NumberFormatException e) {
                this.logger.error("Error parsing AUTOMATIC_ATTACHMENT_DOWNLOAD_SIZE_SETTING_KEY: " + downloadedSizeStr);
                this.automaticAttachmentSizeDlThreshold.set((Object)AutomaticAttachmentSizeDlThreshold.TEN_MO);
            }
        }
        String enterSetting = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.ENTER_TO_SEND);
        if (enterSetting == null) {
            this.enterToSendOptionProp.set((Object)EnterToSendOption.ENTER);
        } else {
            try {
                this.enterToSendOptionProp.set((Object)EnterToSendOption.of(Integer.parseInt(enterSetting)));
            }
            catch (Exception e) {
                this.logger.error("Error parsing ENTER_TO_SEND: " + enterSetting);
                this.enterToSendOptionProp.set((Object)EnterToSendOption.ENTER);
            }
        }
    }

    private void onAppSettingsChanged(List<ApplicationSetting> newValue, List<ApplicationSetting> oldValue) {
        for (ApplicationSetting setting : newValue) {
            switch (setting.getPrefKey()) {
                case SEND_READ_RECEIPT_SETTING_KEY: {
                    boolean value = Boolean.parseBoolean(setting.getPrefValue());
                    this.sendReadReceiptProp.set(value);
                    break;
                }
                case AUTOMATIC_ATTACHMENT_DOWNLOAD_SIZE_SETTING_KEY: {
                    try {
                        int prefIntValue = Integer.parseInt(setting.getPrefValue());
                        this.automaticAttachmentSizeDlThreshold.set((Object)AutomaticAttachmentSizeDlThreshold.of(prefIntValue));
                    }
                    catch (Exception e) {
                        this.logger.error("Error parsing automatic attachment threshold: " + setting.getPrefValue());
                    }
                    break;
                }
                case ENTER_TO_SEND: {
                    try {
                        int prefIntValue = Integer.parseInt(setting.getPrefValue());
                        this.enterToSendOptionProp.set((Object)EnterToSendOption.of(prefIntValue));
                    }
                    catch (Exception e) {
                        this.logger.error("Error parsing ENTER_TO_SEND: " + setting.getPrefValue());
                    }
                    break;
                }
            }
        }
    }

    public void setLaunchOnStart() {
        switch (AppRuntimeHelper.getStartupMode()) {
            case NONE: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.FOREGROUND);
                this.launchOnStartProp.set(true);
                this.launchInBackgroundProp.set(false);
                break;
            }
            case FOREGROUND: 
            case BACKGROUND: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.NONE);
                this.launchOnStartProp.set(false);
                this.launchInBackgroundProp.set(false);
            }
        }
    }

    public void setLaunchInBackground() {
        switch (AppRuntimeHelper.getStartupMode()) {
            case NONE: {
                this.logger.error("Unexpected NONE state");
                break;
            }
            case FOREGROUND: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.BACKGROUND);
                this.launchInBackgroundProp.set(true);
                this.launchOnStartProp.set(true);
                break;
            }
            case BACKGROUND: {
                AppRuntimeHelper.setStartupLaunchMode(AppRuntimeHelper.StartupMode.FOREGROUND);
                this.launchInBackgroundProp.set(false);
                this.launchOnStartProp.set(true);
            }
        }
    }

    public void setSendReadReceipt() {
        boolean current = this.sendReadReceiptProp.get();
        boolean newValue = !current;
        ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.SEND_READ_RECEIPT_SETTING_KEY, String.valueOf(newValue));
        this.sendReadReceiptProp.set(newValue);
    }

    public void plug() {
        this.settingsLiveData.addListener(this.appSettingListener);
    }

    public void unplug() {
        this.settingsLiveData.removeListener(this.appSettingListener);
    }
}

