/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.edit_identity;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.atom.tasks.AtomTasks;
import io.olvid.windows.messenger.engine.helpers.files.FileApi;
import io.olvid.windows.messenger.engine.helpers.owned_identity.OwnedIdentityApi;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class EditIdentitySettingViewModel {
    private final AppLogger logger = new AppLogger(EditIdentitySettingViewModel.class);
    public ObjectProperty<OwnedIdentityInfo> ownedIdentityInfoProperty = new SimpleObjectProperty();
    public final StringProperty firstNameProperty = new SimpleStringProperty();
    public final StringProperty lastNameProperty = new SimpleStringProperty();
    public final StringProperty nicknameProperty = new SimpleStringProperty();
    public final StringProperty companyProperty = new SimpleStringProperty();
    public final StringProperty jobTitleProperty = new SimpleStringProperty();
    public final BooleanProperty editableProperty = new SimpleBooleanProperty(false);
    public final BooleanProperty multiDeviceProperty = new SimpleBooleanProperty(false);
    public final StringProperty photoUrlRelPathProperty = new SimpleStringProperty();
    public final BooleanProperty suppressExternalUpdates = new SimpleBooleanProperty(false);
    public final BooleanProperty photoDirtyProperty = new SimpleBooleanProperty(false);
    public final BooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private Optional<String> importedPhotoPath = Optional.empty();
    private String securePhotoPath = null;
    private boolean deleteImage = false;
    private final LiveDataListener<OwnedIdentityInfo> ownedIdentityListener = this::onOwnedIdentityChanged;
    public final LiveData<OwnedIdentityInfo> ownedIdentityLiveData;

    public EditIdentitySettingViewModel(LiveData<OwnedIdentityInfo> ownedIdentityLiveData) {
        this.ownedIdentityLiveData = ownedIdentityLiveData;
    }

    public void initialize() {
        this.ownedIdentityLiveData.addListener(this.ownedIdentityListener);
    }

    public void dispose() {
        this.ownedIdentityLiveData.removeListener(this.ownedIdentityListener);
        if (this.securePhotoPath != null) {
            this.deleteCustomImageAsync(this.securePhotoPath);
            this.securePhotoPath = null;
        }
    }

    private void onOwnedIdentityChanged(OwnedIdentityInfo newValue, OwnedIdentityInfo oldValue) {
        if (this.suppressExternalUpdates.get() && this.ownedIdentityInfoProperty.get() != null && newValue.genId().equals(((OwnedIdentityInfo)this.ownedIdentityInfoProperty.get()).genId())) {
            return;
        }
        Platform.runLater(() -> {
            if (newValue == null) {
                this.firstNameProperty.set((Object)"");
                this.lastNameProperty.set((Object)"");
                this.nicknameProperty.set((Object)"");
                this.companyProperty.set((Object)"");
                this.jobTitleProperty.set((Object)"");
                this.photoUrlRelPathProperty.set(null);
                this.editableProperty.set(false);
                this.multiDeviceProperty.set(false);
                return;
            }
            this.ownedIdentityInfoProperty.set((Object)newValue);
            IdentityDetailsInfo d = newValue.detailsInfo();
            this.firstNameProperty.set((Object)d.firstName().orElse(""));
            this.lastNameProperty.set((Object)d.lastName().orElse(""));
            this.nicknameProperty.set((Object)newValue.nickname().orElse(""));
            this.companyProperty.set((Object)d.company().orElse(""));
            this.jobTitleProperty.set((Object)d.position().orElse(""));
            this.photoUrlRelPathProperty.set((Object)d.photoUrl().orElse(null));
            boolean isManaged = newValue.isKeycloakManaged();
            boolean transferRestricted = this.isTransferRestricted(newValue.bytesOwnedIdentity());
            this.editableProperty.set(!isManaged && !transferRestricted);
            this.multiDeviceProperty.set(this.hasMultiDevice(newValue.bytesOwnedIdentity()));
        });
    }

    public void onEditPhotoChosen(String absolutePath) {
        if (absolutePath == null || absolutePath.isBlank()) {
            return;
        }
        this.importedPhotoPath = Optional.of(absolutePath);
        AsyncTaskExecutor.submitTask(() -> FileApi._resizeCompressAndEncryptImageTask(absolutePath, 1080, 1080, this::onPhotoPreparedSecurePath, null));
    }

    private void onPhotoPreparedSecurePath(String securePath) {
        Platform.runLater(() -> {
            this.photoUrlRelPathProperty.set((Object)securePath);
            this.securePhotoPath = securePath;
            this.deleteImage = false;
            this.photoDirtyProperty.set(true);
        });
    }

    public void markDeletePhoto() {
        this.photoUrlRelPathProperty.set(null);
        this.deleteImage = true;
        this.importedPhotoPath = Optional.empty();
        this.photoDirtyProperty.set(true);
    }

    public void save() {
        boolean photoChanged;
        OwnedIdentityInfo ownedIdentityInfo = (OwnedIdentityInfo)this.ownedIdentityInfoProperty.get();
        boolean isManaged = ownedIdentityInfo.isKeycloakManaged();
        String firstName = EditIdentitySettingViewModel.trimToNull((String)this.firstNameProperty.get());
        String lastName = EditIdentitySettingViewModel.trimToNull((String)this.lastNameProperty.get());
        String nickname = EditIdentitySettingViewModel.trimToNull((String)this.nicknameProperty.get());
        String company = EditIdentitySettingViewModel.trimToNull((String)this.companyProperty.get());
        String jobTitle = EditIdentitySettingViewModel.trimToNull((String)this.jobTitleProperty.get());
        boolean nicknameChanged = !Objects.equals(nickname, ownedIdentityInfo.nickname().orElse(null));
        boolean detailsChanged = !isManaged && this.haveDetailsChanged(ownedIdentityInfo, firstName, lastName, company, jobTitle);
        boolean bl = photoChanged = this.importedPhotoPath.isPresent() || this.deleteImage;
        if (detailsChanged && EditIdentitySettingViewModel.isBlank(firstName) && EditIdentitySettingViewModel.isBlank(lastName)) {
            this.logger.debug("EditIdentity: details changed but first & last names are empty. Abort details update.");
        }
        if (nicknameChanged) {
            AsyncTaskExecutor.submitTask(() -> this.updateNickname(ownedIdentityInfo.genId(), nickname));
        }
        if (detailsChanged) {
            this.modifyDetails(ownedIdentityInfo.bytesOwnedIdentity(), firstName, lastName, company, jobTitle);
        }
        if (this.importedPhotoPath.isPresent()) {
            this.logger.debug("EditIdentity: importing new photo...");
            this.importAndUpdatePhoto(ownedIdentityInfo.bytesOwnedIdentity(), this.importedPhotoPath.get());
        } else if (this.deleteImage) {
            this.logger.debug("EditIdentity: removing photo...");
            this.removePhoto(ownedIdentityInfo.bytesOwnedIdentity());
        }
        if (this.securePhotoPath != null) {
            this.deleteCustomImageAsync(this.securePhotoPath);
            this.securePhotoPath = null;
        }
        if (photoChanged) {
            this.photoDirtyProperty.set(false);
        }
    }

    public void cancel() {
        OwnedIdentityInfo ownedIdentityInfo = (OwnedIdentityInfo)this.ownedIdentityInfoProperty.get();
        IdentityDetailsInfo d = ownedIdentityInfo.detailsInfo();
        this.firstNameProperty.set((Object)d.firstName().orElse(""));
        this.lastNameProperty.set((Object)d.lastName().orElse(""));
        this.nicknameProperty.set((Object)ownedIdentityInfo.nickname().orElse(""));
        this.companyProperty.set((Object)d.company().orElse(""));
        this.jobTitleProperty.set((Object)d.position().orElse(""));
        this.importedPhotoPath = Optional.empty();
        this.deleteImage = false;
        this.photoUrlRelPathProperty.set(null);
        if (this.securePhotoPath != null) {
            this.deleteCustomImageAsync(this.securePhotoPath);
            this.securePhotoPath = null;
        }
        this.photoDirtyProperty.set(false);
    }

    private boolean haveDetailsChanged(OwnedIdentityInfo info, String firstName, String lastName, String company, String jobTitle) {
        return !Objects.equals(firstName, info.detailsInfo().firstName().orElse(null)) || !Objects.equals(lastName, info.detailsInfo().lastName().orElse(null)) || !Objects.equals(company, info.detailsInfo().company().orElse(null)) || !Objects.equals(jobTitle, info.detailsInfo().position().orElse(null));
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        return t.isEmpty() ? null : t;
    }

    private static boolean isBlank(String s) {
        return s == null || s.isBlank();
    }

    private boolean isTransferRestricted(byte[] bytesOwnedIdentity) {
        return KeycloakManager.getInstance().isOwnedIdentityTransferRestricted(BytesKey.of(bytesOwnedIdentity));
    }

    private boolean hasMultiDevice(byte[] bytesOwnedIdentity) {
        return Api.getDeviceApi().hasMultiDevice(bytesOwnedIdentity);
    }

    private void updateNickname(Id<OwnedIdentity> genId, String nickname) {
        AtomTasks.updateOwnedIdentityNickname(genId, Optional.ofNullable(nickname), true);
    }

    private void modifyDetails(byte[] bytesOwnedIdentity, String firstName, String lastName, String company, String jobTitle) {
        OwnedIdentityApi.modifyOwnedIdentityDetails(bytesOwnedIdentity, firstName, lastName, company, jobTitle);
    }

    private void importAndUpdatePhoto(byte[] bytesOwnedIdentity, String photoPath) {
        OwnedIdentityApi.importAndUpdateOwnedIdentityPhoto(bytesOwnedIdentity, photoPath, null, null);
    }

    private void removePhoto(byte[] bytesOwnedIdentity) {
        OwnedIdentityApi.removeOwnedIdentityPhoto(bytesOwnedIdentity);
    }

    private void deleteCustomImageAsync(String securePhotoPath) {
        FileApi._deleteCustomImageTask(securePhotoPath);
    }
}

