/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.edit_identity;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.CloseGuard;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmModalController;
import io.olvid.windows.messenger.fx.settings.components.KeyTextInputField;
import io.olvid.windows.messenger.fx.settings.edit_identity.EditIdentitySettingViewModel;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.stage.FileChooser;

public class EditIdentitySettingViewController
extends BaseViewController
implements CloseGuard {
    private static final double BADGE_RADIUS = 13.0;
    private static final double ICON_SIZE = 14.5;
    private static final int BUBBLE_SIZE = 43;
    private static final Color BADGE_COLOR = Color.rgb((int)47, (int)101, (int)245);
    private static final String ICON_PATH = "/fx/icons/add_photo_white.png";
    public VBox root = new VBox();
    private final IdentityBubble identityProfilePicture = new IdentityBubble(43.0);
    private final StackPane addPhotoIcon = new StackPane();
    private final KeyTextInputField key = new KeyTextInputField(true);
    private final TextField firstNameField = new TextField();
    private final TextField lastNameField = new TextField();
    private final TextField nicknameField = new TextField();
    private final TextField companyField = new TextField();
    private final TextField jobTitleField = new TextField();
    private final Button saveButton = new Button(ViewControllerHelper.getString("save_button_label"));
    private final Button cancelButton = new Button(ViewControllerHelper.getString("cancel"));
    public final Label firstNameMandatoryMessage = new Label(ViewControllerHelper.getString("firstname_or_lastname_mandatory_message"));
    public final Label lastnameMandatoryMessage = new Label(ViewControllerHelper.getString("firstname_or_lastname_mandatory_message"));
    private final StringProperty initFirst = new SimpleStringProperty("");
    private final StringProperty initLast = new SimpleStringProperty("");
    private final StringProperty initNick = new SimpleStringProperty("");
    private final StringProperty initComp = new SimpleStringProperty("");
    private final StringProperty initJob = new SimpleStringProperty("");
    private final SimpleStringProperty initialUrlPhoto = new SimpleStringProperty();
    private final BooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final BooleanProperty modelReady = new SimpleBooleanProperty(false);
    private final BooleanProperty snapshotReady = new SimpleBooleanProperty(false);
    private final EditIdentitySettingViewModel viewModel;
    private ChangeListener<String> firstnameMandatoryListener;
    private ChangeListener<String> lastnameMandatoryListener;
    private ChangeListener<OwnedIdentityInfo> onOwnedIdentityInfoChangeListener;
    private ChangeListener<String> photoUrlRelPathChangeListener;
    private LiveDataListener<OwnedIdentityInfo> ownedIdentityInfoLDListener = this::onOwnedIdentityLiveDataChange;
    private final SimpleStringProperty titleProperty;
    private final SimpleStringProperty subTitleProperty;

    public EditIdentitySettingViewController(EditIdentitySettingViewModel model, SimpleStringProperty titleProperty, SimpleStringProperty subTitleProperty) {
        this.viewModel = model;
        model.hasChanges.bind((ObservableValue)this.hasChanges);
        this.titleProperty = titleProperty;
        this.subTitleProperty = subTitleProperty;
        this.root.setSpacing(20.0);
        this.root.setPadding(new Insets(24.0, 24.0, 0.0, 24.0));
        this.root.getChildren().addAll((Object[])new Node[]{this.buildIdentityBubbleContainer(), this.buildForm(), this.buildActions()});
        this.bindFieldsToViewModel();
        this.bindDirtyFromSnapshot();
        this.viewModel.suppressExternalUpdates.bind((ObservableValue)this.hasChanges);
        this.firstNameField.editableProperty().bind((ObservableValue)this.viewModel.editableProperty);
        this.lastNameField.editableProperty().bind((ObservableValue)this.viewModel.editableProperty);
        this.companyField.editableProperty().bind((ObservableValue)this.viewModel.editableProperty);
        this.jobTitleField.editableProperty().bind((ObservableValue)this.viewModel.editableProperty);
        this.saveButton.setOnAction(this::onSave);
        this.cancelButton.setOnAction(this::onCancel);
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.viewModel.initialize();
        this.bindButtons();
        this.setupListeners();
        this.titleProperty.set(ViewControllerHelper.getString("edit_identity_settings_button_text"));
    }

    @Override
    public void onLayoutDetached() {
        this.viewModel.dispose();
        this.unbindButtons();
        this.removeListeners();
    }

    public BooleanProperty hasChangesProperty() {
        return this.hasChanges;
    }

    @Override
    public void saveChangesSilently() {
        this.viewModel.save();
        this.captureInitialSnapshot();
        this.modelReady.set(true);
    }

    @Override
    public void discardChangesSilently() {
        this.viewModel.cancel();
        this.captureInitialSnapshot();
        this.modelReady.set(true);
    }

    private StackPane buildIdentityBubbleContainer() {
        StackPane container = new StackPane();
        container.getStyleClass().add((Object)"identity-bubble-container");
        this.identityProfilePicture.getStyleClass().add((Object)"hand-hoverable");
        container.getChildren().add((Object)this.identityProfilePicture);
        this.addPhotoIcon.setTranslateX(43.0 / Math.sqrt(2.0));
        this.addPhotoIcon.setTranslateY(43.0 / Math.sqrt(2.0));
        this.addPhotoIcon.getStyleClass().add((Object)"hand-hoverable");
        this.addPhotoIcon.setPickOnBounds(false);
        Circle bg = new Circle(13.0);
        bg.setFill((Paint)BADGE_COLOR);
        URL iconUrl = Objects.requireNonNull(ViewControllerHelper.class.getResource(ICON_PATH), "Ressource manquante: /fx/icons/add_photo_white.png");
        ImageView icon = new ImageView(new Image(iconUrl.toExternalForm()));
        icon.setFitWidth(14.5);
        icon.setFitHeight(14.5);
        icon.setPreserveRatio(true);
        this.addPhotoIcon.getChildren().setAll((Object[])new Node[]{bg, icon});
        container.getChildren().add((Object)this.addPhotoIcon);
        this.identityProfilePicture.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                this.photoChoiceModal();
            }
        });
        this.addPhotoIcon.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                this.photoChoiceModal();
            }
        });
        return container;
    }

    private VBox buildForm() {
        VBox form = new VBox(16.0);
        form.setPadding(new Insets(8.0, 24.0, 24.0, 24.0));
        VBox nickname = this.createField("nickname", this.nicknameField, "visible_by_me", "nickname_prompt_text", null);
        HBox nickLine = new HBox(16.0, new Node[]{nickname});
        HBox.setHgrow((Node)nickname, (Priority)Priority.ALWAYS);
        nickLine.setPrefHeight(88.0);
        VBox firstName = this.createField("firstname", this.firstNameField, null, "firstname_prompt_text", this.firstNameMandatoryMessage);
        VBox lastName = this.createField("lastname", this.lastNameField, null, "lastname_prompt_text", this.lastnameMandatoryMessage);
        HBox nameLine = new HBox(16.0, new Node[]{firstName, lastName});
        nameLine.setPrefHeight(88.0);
        HBox.setHgrow((Node)firstName, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)lastName, (Priority)Priority.ALWAYS);
        VBox company = this.createField("company", this.companyField, null, "company_prompt_text", null);
        VBox job = this.createField("position", this.jobTitleField, null, "position_prompt_text", null);
        HBox jobLine = new HBox(16.0, new Node[]{company, job});
        jobLine.setPrefHeight(88.0);
        HBox.setHgrow((Node)company, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)job, (Priority)Priority.ALWAYS);
        form.getChildren().addAll((Object[])new Node[]{nickLine, nameLine, jobLine});
        return form;
    }

    private VBox buildActions() {
        VBox actions = new VBox(8.0);
        actions.setPadding(new Insets(8.0, 24.0, 24.0, 24.0));
        this.saveButton.getStyleClass().addAll((Object[])new String[]{"button", "primary-button"});
        this.cancelButton.getStyleClass().addAll((Object[])new String[]{"button", "secondary-button"});
        this.saveButton.setMaxWidth(Double.MAX_VALUE);
        this.cancelButton.setMaxWidth(Double.MAX_VALUE);
        actions.getChildren().addAll((Object[])new Node[]{this.saveButton, this.cancelButton});
        return actions;
    }

    private void bindFieldsToViewModel() {
        this.firstNameField.textProperty().bindBidirectional((Property)this.viewModel.firstNameProperty);
        this.lastNameField.textProperty().bindBidirectional((Property)this.viewModel.lastNameProperty);
        this.nicknameField.textProperty().bindBidirectional((Property)this.viewModel.nicknameProperty);
        this.companyField.textProperty().bindBidirectional((Property)this.viewModel.companyProperty);
        this.jobTitleField.textProperty().bindBidirectional((Property)this.viewModel.jobTitleProperty);
    }

    private static String norm(String s) {
        return s == null ? "" : s.trim();
    }

    private void bindDirtyFromSnapshot() {
        BooleanBinding dirtyCore = Bindings.createBooleanBinding(() -> !Objects.equals(EditIdentitySettingViewController.norm(this.firstNameField.getText()), EditIdentitySettingViewController.norm((String)this.initFirst.get())) || !Objects.equals(EditIdentitySettingViewController.norm(this.lastNameField.getText()), EditIdentitySettingViewController.norm((String)this.initLast.get())) || !Objects.equals(EditIdentitySettingViewController.norm(this.nicknameField.getText()), EditIdentitySettingViewController.norm((String)this.initNick.get())) || !Objects.equals(EditIdentitySettingViewController.norm(this.companyField.getText()), EditIdentitySettingViewController.norm((String)this.initComp.get())) || !Objects.equals(EditIdentitySettingViewController.norm(this.jobTitleField.getText()), EditIdentitySettingViewController.norm((String)this.initJob.get())) || !Objects.equals(EditIdentitySettingViewController.norm((String)this.viewModel.photoUrlRelPathProperty.get()), EditIdentitySettingViewController.norm(this.initialUrlPhoto.get())), (Observable[])new Observable[]{this.firstNameField.textProperty(), this.lastNameField.textProperty(), this.nicknameField.textProperty(), this.companyField.textProperty(), this.jobTitleField.textProperty(), this.initFirst, this.initLast, this.initNick, this.initComp, this.initJob, this.viewModel.photoUrlRelPathProperty, this.initialUrlPhoto});
        this.hasChanges.bind((ObservableValue)this.modelReady.and((ObservableBooleanValue)dirtyCore));
    }

    private void bindButtons() {
        BooleanBinding bothNamesEmpty = Bindings.createBooleanBinding(() -> !(this.firstNameField.getText() != null && !this.firstNameField.getText().isBlank() || this.lastNameField.getText() != null && !this.lastNameField.getText().isBlank()), (Observable[])new Observable[]{this.firstNameField.textProperty(), this.lastNameField.textProperty()});
        BooleanBinding namesDirty = Bindings.createBooleanBinding(() -> !Objects.equals(EditIdentitySettingViewController.norm(this.firstNameField.getText()), EditIdentitySettingViewController.norm((String)this.initFirst.get())) || !Objects.equals(EditIdentitySettingViewController.norm(this.lastNameField.getText()), EditIdentitySettingViewController.norm((String)this.initLast.get())), (Observable[])new Observable[]{this.firstNameField.textProperty(), this.lastNameField.textProperty(), this.initFirst, this.initLast});
        BooleanBinding savingNamesInvalid = bothNamesEmpty.and((ObservableBooleanValue)namesDirty);
        this.saveButton.disableProperty().bind((ObservableValue)this.hasChanges.not().or((ObservableBooleanValue)savingNamesInvalid));
        this.cancelButton.disableProperty().bind((ObservableValue)this.hasChanges.not());
    }

    private void unbindButtons() {
        this.saveButton.disableProperty().unbind();
        this.cancelButton.disableProperty().unbind();
    }

    private void setupListeners() {
        this.firstnameMandatoryListener = (obs, old, newVal) -> this.toggleMandatory((String)newVal, this.lastNameField.getText());
        this.lastnameMandatoryListener = (obs, old, newVal) -> this.toggleMandatory(this.firstNameField.getText(), (String)newVal);
        this.onOwnedIdentityInfoChangeListener = (obs, oldV, newV) -> Platform.runLater(() -> {
            boolean identityChanged;
            this.initialUrlPhoto.set((String)newV.detailsInfo().photoUrl().orElse(null));
            BubbleUtils.setBubbleData(newV, this.identityProfilePicture);
            boolean bl = identityChanged = !Objects.equals(oldV, newV);
            if (!this.modelReady.get() || identityChanged) {
                this.captureInitialSnapshot();
                this.modelReady.set(true);
            }
        });
        this.photoUrlRelPathChangeListener = (obs, o, n) -> Platform.runLater(() -> this.identityProfilePicture.setPhotoUrlRelPath(n == null ? Optional.empty() : Optional.of(n)));
        this.firstNameField.textProperty().addListener(this.firstnameMandatoryListener);
        this.lastNameField.textProperty().addListener(this.lastnameMandatoryListener);
        this.viewModel.ownedIdentityInfoProperty.addListener(this.onOwnedIdentityInfoChangeListener);
        this.viewModel.photoUrlRelPathProperty.addListener(this.photoUrlRelPathChangeListener);
        this.toggleMandatory(this.firstNameField.getText(), this.lastNameField.getText());
        this.viewModel.ownedIdentityLiveData.addListener(this.ownedIdentityInfoLDListener);
    }

    private void removeListeners() {
        this.firstNameField.textProperty().removeListener(this.firstnameMandatoryListener);
        this.lastNameField.textProperty().removeListener(this.lastnameMandatoryListener);
        this.viewModel.ownedIdentityInfoProperty.removeListener(this.onOwnedIdentityInfoChangeListener);
        this.viewModel.photoUrlRelPathProperty.removeListener(this.photoUrlRelPathChangeListener);
        this.viewModel.ownedIdentityLiveData.removeListener(this.ownedIdentityInfoLDListener);
    }

    private void toggleMandatory(String firstName, String lastName) {
        boolean firstBlank = firstName == null || firstName.isBlank();
        boolean lastBlank = lastName == null || lastName.isBlank();
        boolean show = firstBlank && lastBlank;
        this.firstNameMandatoryMessage.setVisible(show);
        this.lastnameMandatoryMessage.setVisible(show);
    }

    public void captureInitialSnapshot() {
        this.initFirst.set((Object)this.firstNameField.getText());
        this.initLast.set((Object)this.lastNameField.getText());
        this.initNick.set((Object)this.nicknameField.getText());
        this.initComp.set((Object)this.companyField.getText());
        this.initJob.set((Object)this.jobTitleField.getText());
        this.initialUrlPhoto.set((String)this.viewModel.photoUrlRelPathProperty.get());
        this.titleProperty.set(ViewControllerHelper.getString("edit_identity_settings_button_text"));
        this.subTitleProperty.set("(" + this.lastNameField.getText() + " " + this.firstNameField.getText() + ")");
        this.snapshotReady.set(true);
    }

    private void onSave(ActionEvent e) {
        if (!this.hasChanges.get()) {
            return;
        }
        this.confirmModal(ViewControllerHelper.getString("modal_save_title"), ViewControllerHelper.getString("modal_save_description"), FxIcons.CHECK((Paint)Color.BLUE, null), () -> {
            this.viewModel.save();
            this.captureInitialSnapshot();
            this.modelReady.set(true);
        }, () -> {}, ConfirmModalController.BadgeKind.PRIMARY, ViewControllerHelper.getString("modal_save_button_confirm"), ViewControllerHelper.getString("modal_save_button_cancel"));
    }

    private void onCancel(ActionEvent e) {
        if (!this.hasChanges.get()) {
            return;
        }
        this.confirmModal(ViewControllerHelper.getString("modal_cancel_title"), ViewControllerHelper.getString("modal_cancel_description"), FxIcons.BAN((Paint)Color.RED, null), () -> {
            this.viewModel.cancel();
            this.captureInitialSnapshot();
            this.modelReady.set(true);
            OwnedIdentityInfo cur = (OwnedIdentityInfo)this.viewModel.ownedIdentityInfoProperty.get();
            BubbleUtils.setBubbleData(cur, this.identityProfilePicture);
            this.viewModel.photoUrlRelPathProperty.set((Object)this.initialUrlPhoto.get());
        }, () -> {}, ConfirmModalController.BadgeKind.DANGER, ViewControllerHelper.getString("modal_cancel_button_confirm"), ViewControllerHelper.getString("modal_cancel_button_cancel"));
    }

    private void photoChoiceModal() {
        Runnable choosePhoto = () -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle(ViewControllerHelper.getString("photo_chooser_title"));
            String homePath = AppRuntimeHelper.USER_HOME_DIR_ABSOLUTE_PATH;
            File homeFile = homePath == null ? null : new File(homePath);
            fileChooser.setInitialDirectory(homeFile);
            File photo = fileChooser.showOpenDialog(ViewControllerHelper.MAIN_STAGE.getOwner());
            if (photo != null && !photo.getAbsolutePath().isEmpty()) {
                this.viewModel.onEditPhotoChosen(photo.getAbsolutePath());
            }
        };
        ConfirmModalController confirmModal = new ConfirmModalController(450.0);
        String editPhotoBtnLabel = ViewControllerHelper.getString("edit_identity_settings_modify_profile_picture");
        String deletePhotoBtnLabel = ViewControllerHelper.getString("edit_identity_settings_delete_profile_picture");
        String cancelBtnLabel = ViewControllerHelper.getString("modal.cancel");
        List<ConfirmModalController.ConfirmationAction> actions = this.identityProfilePicture.getPhotoUrlRelPath() != null && !this.identityProfilePicture.getPhotoUrlRelPath().isEmpty() || this.viewModel.photoUrlRelPathProperty.get() != null && !((String)this.viewModel.photoUrlRelPathProperty.get()).isEmpty() ? List.of(ConfirmModalController.ConfirmationAction.of(editPhotoBtnLabel, List.of("button-outline"), choosePhoto).asDefault(), ConfirmModalController.ConfirmationAction.of(deletePhotoBtnLabel, List.of("button-outline", "button-outline-danger"), this::markDeletePhoto), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), () -> {}).asCancel()) : List.of(ConfirmModalController.ConfirmationAction.of(editPhotoBtnLabel, List.of("button-outline"), choosePhoto).asDefault(), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), () -> {}).asCancel());
        confirmModal.configure("Modifier la photo de profil", null, null, actions);
        confirmModal.setBadgeKind(ConfirmModalController.BadgeKind.PRIMARY);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirmModal, false));
    }

    private void markDeletePhoto() {
        this.viewModel.markDeletePhoto();
        this.identityProfilePicture.setPhotoUrlRelPath(Optional.empty());
    }

    private void confirmModal(String title, String description, FxIcons.IconDef icon, Runnable onValidCallback, Runnable onCancelCallback, ConfirmModalController.BadgeKind badge, String validBtnLabel, String cancelBtnLabel) {
        ConfirmModalController confirmModal = new ConfirmModalController(450.0);
        String outlineButtonStyles = "primary-button";
        if (badge == ConfirmModalController.BadgeKind.DANGER) {
            outlineButtonStyles = "warning-button";
        }
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(validBtnLabel, List.of(outlineButtonStyles), onValidCallback).asDefault(), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), onCancelCallback).asCancel());
        confirmModal.configure(title, description, FxIcons.icon(icon, 20.0, 20.0), actions);
        confirmModal.setBadgeKind(badge);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirmModal, false));
    }

    private VBox createField(String labelText, TextField field, String helperText, String promptText, Label mandatoryMessage) {
        Label label = new Label(ViewControllerHelper.getString(labelText));
        label.getStyleClass().addAll((Object[])new String[]{"body-1"});
        VBox box = new VBox(2.0);
        box.setPrefHeight(50.0);
        HBox header = new HBox(6.0);
        header.setPrefWidth(400.0);
        if (helperText != null) {
            Label helper = new Label("(" + ViewControllerHelper.getString(helperText) + ")");
            helper.getStyleClass().addAll((Object[])new String[]{"body-1", "helper-text"});
            header.getChildren().addAll((Object[])new Node[]{label, helper});
            box.getChildren().add((Object)header);
        } else {
            box.getChildren().add((Object)label);
        }
        if (promptText != null) {
            field.setPromptText(ViewControllerHelper.getString(promptText));
        }
        field.getStyleClass().add((Object)"text-field-header-label");
        box.getChildren().add((Object)field);
        if (mandatoryMessage != null) {
            mandatoryMessage.getStyleClass().add((Object)"error-text");
            mandatoryMessage.setVisible(false);
            mandatoryMessage.setManaged(true);
            box.getChildren().add((Object)mandatoryMessage);
        }
        return box;
    }

    private void onOwnedIdentityLiveDataChange(OwnedIdentityInfo newValue, OwnedIdentityInfo oldValue) {
        Platform.runLater(() -> {
            boolean identityChanged;
            boolean bl = identityChanged = !Objects.equals(oldValue == null ? null : oldValue.genId(), newValue == null ? null : newValue.genId());
            if (!this.modelReady.get() || identityChanged) {
                BubbleUtils.setBubbleData(newValue, this.identityProfilePicture);
                this.captureInitialSnapshot();
                this.modelReady.set(true);
            }
        });
    }
}

