/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.devices;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.sync.RenameDeviceController;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmModalController;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class DeviceSettingsViewModel {
    private final ListProperty<OwnedDevice> ownedDeviceList = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<OwnedIdentityInfo> ownedIdentityInfoProperty = new SimpleObjectProperty();
    private final BooleanProperty multiDeviceProperty = new SimpleBooleanProperty(false);
    private final LiveDataListener<OwnedIdentityInfo> ownedIdentityListener = this::onOwnedIdentityChanged;
    private LiveData<OwnedIdentityInfo> ownedIdentityLiveData;
    private Runnable closeModalDelegate;
    private final ExecutorService bg = Executors.newSingleThreadExecutor();
    private final LiveData<List<OwnedDevice>> ownedDevices = LiveDataFactory.buildDbLiveDataList(OwnedDevice.class, () -> {
        if (this.ownedIdentityInfoProperty.get() == null) {
            return List.of();
        }
        return DbManager.getInstance().getOwnedDeviceDao().getAllSync(((OwnedIdentityInfo)this.ownedIdentityInfoProperty.get()).genId());
    });

    public DeviceSettingsViewModel(Runnable closeModalDelegate, LiveData<OwnedIdentityInfo> ownedIdentityLiveData) {
        this.closeModalDelegate = closeModalDelegate;
        this.ownedIdentityLiveData = ownedIdentityLiveData;
        this.ownedIdentityLiveData.addListener(this.ownedIdentityListener);
        this.ownedDevices.addListener(this::onOwnedDeviceChanged);
    }

    public ListProperty<OwnedDevice> ownedDeviceListProperty() {
        return this.ownedDeviceList;
    }

    public ObjectProperty<OwnedIdentityInfo> ownedIdentityInfoProperty() {
        return this.ownedIdentityInfoProperty;
    }

    public BooleanProperty multiDeviceProperty() {
        return this.multiDeviceProperty;
    }

    public void addDevice() {
        this.confirmModal(ViewControllerHelper.getString("confirmation_add_device_title"), ViewControllerHelper.getString("confirmation_add_device_subtext"), FxIcons.CHECK((Paint)Color.BLUE, null), this::OnValidateAddDevice, ConfirmModalController.BadgeKind.PRIMARY, ViewControllerHelper.getString("button_label_proceed"));
    }

    private void OnValidateAddDevice() {
        this.closeModalDelegate.run();
        OwnedIdentityInfo info = (OwnedIdentityInfo)this.ownedIdentityInfoProperty.get();
        MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT));
        Api.getTransferApi().initiateOwnedIdentityTransferProtocolOnSourceDevice(info);
    }

    private void confirmModal(String title, String description, FxIcons.IconDef icon, Runnable onValidCallback, ConfirmModalController.BadgeKind badge, String validButton) {
        ConfirmModalController confirmModal = new ConfirmModalController(450.0);
        String validBtnLabel = validButton;
        String cancelBtnLabel = ViewControllerHelper.getString("modal.cancel");
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(validBtnLabel, List.of("primary-button"), onValidCallback).asDefault(), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), () -> {}).asCancel());
        confirmModal.configure(title, description, FxIcons.icon(icon, 20.0, 20.0), actions);
        confirmModal.setBadgeKind(badge);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirmModal, false));
    }

    public void renameDevice(OwnedDevice ownedDevice) {
        OwnedIdentityInfo info = (OwnedIdentityInfo)this.ownedIdentityInfoProperty.get();
        RenameDeviceController modalController = new RenameDeviceController(info, ownedDevice, ownedDevice.getDisplayNameOrDeviceHexName());
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(modalController, false));
    }

    private void onOwnedIdentityChanged(OwnedIdentityInfo newValue, OwnedIdentityInfo oldValue) {
        if (Objects.equals(newValue, oldValue)) {
            return;
        }
        AsyncTaskExecutor.submitTask(() -> {
            List<OwnedDevice> devices = DbManager.getInstance().getOwnedDeviceDao().getAllSync(newValue.genId());
            List<OwnedDevice> sorted = devices.stream().sorted(Comparator.comparing(d -> !d.isCurrentDevice())).toList();
            boolean multi = Api.getDeviceApi().hasMultiDevice(newValue.bytesOwnedIdentity());
            Platform.runLater(() -> {
                this.ownedIdentityInfoProperty.set((Object)newValue);
                this.ownedDeviceList.setAll((Collection)sorted);
                this.multiDeviceProperty.set(multi);
            });
        });
    }

    private void onOwnedDeviceChanged(List<OwnedDevice> newValue, List<OwnedDevice> oldValue) {
        AsyncTaskExecutor.submitTask(() -> {
            List<OwnedDevice> sorted = newValue.stream().sorted(Comparator.comparing(d -> !d.isCurrentDevice())).toList();
            Platform.runLater(() -> this.ownedDeviceList.setAll((Collection)sorted));
        });
    }

    public void dispose() {
        this.ownedIdentityLiveData.removeListener(this.ownedIdentityListener);
    }
}

