/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.setup;

import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.backups.KeyDisplayView;
import io.olvid.windows.messenger.fx.settings.backups.setup.BackupConfigurationChoiceView;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupConfigurationChoiceModalController
extends BaseModalController {
    private static final Logger log = LoggerFactory.getLogger(BackupConfigurationChoiceModalController.class);
    public final HBox header = new HBox();
    public final Label title = new Label();
    public final Region sep = new Region();
    public final SvgSizeable closeIcon = new SvgSizeable();
    public final StackPane iconContainer = new StackPane();
    public final VBox rootContainer = new VBox();
    BackupConfigurationChoiceView backupConfigurationChoiceView = new BackupConfigurationChoiceView();
    public final Button validateButton = new Button();
    BackupSettingsViewModel model;
    public final Button resetButton = new Button("Reset Key");

    public BackupConfigurationChoiceModalController(BackupSettingsViewModel model) {
        this.model = model;
        this.rootContainer.getStylesheets().add((Object)"fx/modal/settings/settings.css");
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        this.title.setText(ViewControllerHelper.getString("advanced_label"));
        this.closeIcon.getStyleClass().addAll((Object[])new String[]{"svg-close", "icon-medium", "hand-hoverable"});
        this.iconContainer.getChildren().addAll((Object[])new Node[]{this.closeIcon});
        this.iconContainer.setOnMouseClicked(event -> this.closeModalDelegate.run());
        this.title.getStyleClass().addAll((Object[])new String[]{"h1"});
        HBox.setHgrow((Node)this.sep, (Priority)Priority.ALWAYS);
        this.header.setPrefHeight(86.0);
        this.header.setMaxWidth(555.0);
        this.header.setAlignment(Pos.CENTER);
        this.header.getChildren().addAll((Object[])new Node[]{this.title, this.sep, this.iconContainer});
        this.header.setPadding(new Insets(32.0, 14.0, 10.0, 18.0));
        this.backupConfigurationChoiceView.disableBackupButton.setPrefHeight(125.0);
        this.backupConfigurationChoiceView.enableBackupButton.setPrefHeight(125.0);
        this.resetButton.setOnAction(actionEvent -> {
            Optional<String> seed;
            try {
                seed = Api.getBackupApi().getDeviceBackupSeed();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            seed.ifPresent(s -> Api.getBackupApi().deleteDeviceBackupSeed((String)s));
        });
        this.validateButton.getStyleClass().addAll((Object[])new String[]{"primary-button"});
        this.validateButton.setText(ViewControllerHelper.getString("confirm_label"));
        HBox.setHgrow((Node)this.validateButton, (Priority)Priority.ALWAYS);
        HBox buttonContainer = new HBox();
        buttonContainer.setAlignment(Pos.CENTER);
        this.validateButton.setMinWidth(525.0);
        VBox.setMargin((Node)this.validateButton, (Insets)new Insets(15.0, 0.0, 15.0, 0.0));
        this.validateButton.setOnMouseClicked(this::onValidateClicked);
        this.validateButton.disableProperty().bind((ObservableValue)this.backupConfigurationChoiceView.toggleGroup.selectedToggleProperty().isNull());
        this.rootContainer.setAlignment(Pos.TOP_CENTER);
        this.rootContainer.setSpacing(12.0);
        this.rootContainer.setMaxWidth(565.0);
        this.rootContainer.setMaxHeight(368.0);
        this.rootContainer.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background"});
        this.rootContainer.getStylesheets().add((Object)"fx/modal/settings/settings.css");
        if (AppRuntimeHelper.isDevMode) {
            this.rootContainer.getChildren().addAll((Object[])new Node[]{this.header, this.backupConfigurationChoiceView, this.resetButton, this.validateButton});
        } else {
            this.rootContainer.getChildren().addAll((Object[])new Node[]{this.header, this.backupConfigurationChoiceView, this.validateButton});
        }
    }

    protected void onValidateClicked(MouseEvent mouseEvent) {
        this.logger.debug("BackupConfigurationChoiceModalController::onValidateClicked clicked");
        if (this.backupConfigurationChoiceView.selectedToggleProperty.get() == null) {
            this.logger.error("BackupConfigurationChoiceModalController::onValidateClicked nothing selected, this should not happen");
        }
        switch ((BackupConfigurationChoiceView.BackupConfiguration)this.backupConfigurationChoiceView.selectedToggleProperty.get()) {
            case BACKUPS_NO_PASSWORD_MANAGER: {
                if (!this.model.generateDeviceBackupSeed()) {
                    this.logger.error("BackupConfigurationChoiceModalController::onValidatedClicked could'nt generate seed");
                    this.closeModalDelegate.run();
                    return;
                }
                KeyDisplayView displayView = new KeyDisplayView();
                displayView.copyHyperlink.setOnMouseClicked(event -> {
                    Clipboard clipboard = Clipboard.getSystemClipboard();
                    ClipboardContent content = new ClipboardContent();
                    content.putString(displayView.key.getText());
                    clipboard.setContent((Map)content);
                });
                displayView.doneButton.setOnMouseClicked(event -> this.closeModalDelegate.run());
                displayView.closeIconContainer.setOnMouseClicked(event -> this.closeModalDelegate.run());
                displayView.key.textProperty().bind((ObservableValue)this.model.seedProperty);
                displayView.getStylesheets().addAll((Object[])new String[]{"fx/modal/settings/settings.css"});
                this.rootContainer.getChildren().setAll((Object[])new Node[]{displayView});
                break;
            }
            case NO_BACKUPS: {
                this.closeModalDelegate.run();
            }
        }
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutDetached() {
    }
}

