/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.management.backup_management_display;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.custom_components.loader.RingProgressIndicator;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.generic_types.list_view.StandardPanelListController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.backups.management.DeviceBackupListCell;
import io.olvid.windows.messenger.fx.settings.backups.management.ProfileBackupSnapshotCell;
import io.olvid.windows.messenger.fx.settings.backups.management.backup_management_display.BackupManagementUserAction;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.util.Callback;

public class BackupManagementViewController
extends BaseModalController {
    public final VBox rootContainer = new VBox();
    public final HBox headerContainer = new HBox();
    public final SvgSizeable previousIcon = new SvgSizeable();
    public final StackPane previousIconContainer = new StackPane();
    public final Label headerLabel = new Label();
    public final SvgSizeable closeIcon = new SvgSizeable();
    public final StackPane closeIconContainer = new StackPane();
    private final StandardPanelListController<DeviceBackupInfo> deviceBackupListController;
    private final StandardPanelListController<ProfileBackupsInfo> profileBackupListController;
    final RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
    final StackPane ringContainer = new StackPane(new Node[]{this.ringProgressIndicator});
    final StackPane ringOrLoadedList = new StackPane();
    final BackupManagementUserAction backupSettingViewContext = new BackupManagementUserAction();
    final BackupSettingsViewModel backupSettingsViewModel;

    public BackupManagementViewController(BackupSettingsViewModel model) {
        this.backupSettingsViewModel = model;
        this.previousIcon.getStyleClass().addAll((Object[])new String[]{"svg-arrow-left", "icon-medium"});
        this.previousIconContainer.getChildren().addAll((Object[])new Node[]{this.previousIcon});
        this.previousIconContainer.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupManagementDataState.PROFILE_BACKUP_LIST_LOADED));
        this.previousIconContainer.setOnMouseClicked(event -> this.backupSettingsViewModel.fetchDeviceBackupList());
        this.headerLabel.setAlignment(Pos.CENTER);
        this.headerLabel.setTextAlignment(TextAlignment.CENTER);
        this.headerLabel.setText(ViewControllerHelper.getString("manage_olvid_backups_button_label"));
        this.headerLabel.getStyleClass().addAll((Object[])new String[]{"h1"});
        Region rightSep = new Region();
        Region leftSep = new Region();
        HBox.setHgrow((Node)rightSep, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)leftSep, (Priority)Priority.ALWAYS);
        this.closeIcon.getStyleClass().addAll((Object[])new String[]{"svg-close", "icon-medium", "hand-hoverable"});
        this.closeIconContainer.getChildren().addAll((Object[])new Node[]{this.closeIcon});
        this.closeIconContainer.setOnMouseClicked(event -> this.closeModalDelegate.run());
        this.closeIconContainer.setAlignment(Pos.CENTER_RIGHT);
        this.headerContainer.setAlignment(Pos.CENTER);
        this.headerContainer.getChildren().addAll((Object[])new Node[]{this.previousIconContainer, leftSep, this.headerLabel, rightSep, this.closeIconContainer});
        this.headerContainer.setMaxWidth(500.0);
        this.headerContainer.setPadding(new Insets(16.0, 16.0, 8.0, 8.0));
        this.ringProgressIndicator.getStyleClass().setAll((Object[])new String[]{"sync-progress-indicator", "indeterminate"});
        this.ringProgressIndicator.setProgress(-1);
        this.ringProgressIndicator.setInnerCircleRadius(8);
        this.ringProgressIndicator.setRingWidth(2);
        this.ringContainer.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupManagementDataState.LOADING));
        this.ringContainer.managedProperty().bind((ObservableValue)this.ringContainer.visibleProperty());
        this.deviceBackupListController = StandardPanelListController.builder().withLiveData(model.getDeviceBackupProfilesLD()).withDataClass(DeviceBackupInfo.class).withCellFactory((Callback<ListView<DeviceBackupInfo>, AbstractListCell<DeviceBackupInfo>>)((Callback)param -> new DeviceBackupListCell(false))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withSingleSelection().withDisableUnselect(true).withoutButton((deviceBackupInfo, node) -> {
            model.selectedDeviceBackupInfo.set(deviceBackupInfo);
            this.backupSettingsViewModel.fetchProfileBackupList(deviceBackupInfo.ownedIdentityBytes(), deviceBackupInfo.profileBackupSeed());
        }).build();
        this.deviceBackupListController.getLayout().visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupManagementDataState.DEVICE_BACKUP_LIST_LOADED));
        this.deviceBackupListController.getLayout().managedProperty().bind((ObservableValue)this.deviceBackupListController.getLayout().visibleProperty());
        this.deviceBackupListController.getLayout().setPadding(new Insets(0.0, 0.0, 12.0, 0.0));
        this.deviceBackupListController.getLayout().getStyleClass().add((Object)"rounded-background-pane");
        this.profileBackupListController = StandardPanelListController.builder().withLiveData(model.getProfileSnapshots()).withDataClass(ProfileBackupsInfo.class).withCellFactory((Callback<ListView<ProfileBackupsInfo>, AbstractListCell<ProfileBackupsInfo>>)((Callback)param -> new ProfileBackupSnapshotCell(true, Optional.of(model)))).withoutBottomMargin().defaultComparator().noFilter().withoutSearch().withoutSelection().withoutButton().build();
        this.profileBackupListController.getLayout().visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupManagementDataState.PROFILE_BACKUP_LIST_LOADED));
        this.profileBackupListController.getLayout().managedProperty().bind((ObservableValue)this.profileBackupListController.getLayout().visibleProperty());
        this.profileBackupListController.getLayout().setPadding(new Insets(0.0, 0.0, 12.0, 0.0));
        this.profileBackupListController.getLayout().getStyleClass().add((Object)"rounded-background-pane");
        this.ringOrLoadedList.getChildren().addAll((Object[])new Node[]{this.ringContainer, this.profileBackupListController.getLayout(), this.deviceBackupListController.getLayout()});
        this.ringOrLoadedList.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.ringOrLoadedList, (Priority)Priority.ALWAYS);
        this.rootContainer.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background", "round-pane"});
        this.rootContainer.setMinWidth(500.0);
        this.rootContainer.setMinHeight(550.0);
        this.rootContainer.setAlignment(Pos.TOP_CENTER);
        this.rootContainer.setSpacing(24.0);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.headerContainer, this.ringOrLoadedList});
        this.rootContainer.getStylesheets().addAll((Object[])new String[]{"fx/modal/settings/settings.css"});
        this.backupSettingsViewModel.fetchDeviceBackupList();
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    public static enum BackupManagementDataState {
        DEVICE_BACKUP_LIST_LOADED,
        PROFILE_BACKUP_LIST_LOADED,
        BACKUP_NOW_SUCCESS,
        BACKUP_NOW_IN_PROGRESS,
        LOADING,
        ERROR;

    }
}

