/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.configuration.EngineConfiguration;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.engine.helpers.helpers.BackupApiHelper;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.backups.ErrorModalController;
import io.olvid.windows.messenger.fx.settings.backups.management.backup_management_display.BackupManagementViewController;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupFetchResult;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.ByteArray;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class BackupSettingsViewModel {
    private final AppLogger logger = new AppLogger(BackupSettingsViewModel.class);
    public final StringProperty seedProperty = new SimpleStringProperty();
    private final MutableLiveData<List<DeviceBackupInfo>> deviceBackupProfiles = new MutableLiveData(List.of());
    private final MutableLiveData<List<ProfileBackupsInfo>> profileBackupSnapshot = new MutableLiveData(List.of());
    private final ObjectProperty<ProfileBackupFetchResult> profileBackupsInfoFetchResult = new SimpleObjectProperty();
    public final ObjectProperty<DeviceBackupInfo> selectedDeviceBackupInfo = new SimpleObjectProperty();
    public final ObjectProperty<DeviceBackupFetchResult.FetchStatus> deviceBackupFetchStatus = new SimpleObjectProperty();
    public final ObjectProperty<ProfileBackupFetchResult.FetchStatus> profileBackupFetchStatus = new SimpleObjectProperty();
    public final ObjectProperty<BackupManagementViewController.BackupManagementDataState> dataStateProp = new SimpleObjectProperty();
    public final StringProperty error = new SimpleStringProperty();
    public final BooleanProperty fetchFailed = new SimpleBooleanProperty();

    public BackupSettingsViewModel() {
        try {
            Optional<String> seed = Api.getBackupApi().getDeviceBackupSeed();
            seed.ifPresent(arg_0 -> ((StringProperty)this.seedProperty).setValue(arg_0));
        }
        catch (Exception e) {
            this.logger.error("SettingsModalModel::Unexpected state ", e);
        }
    }

    public void fetchProfileBackupList(ByteArray byteArray, String profileSeed) {
        AsyncTaskExecutor.submitTask(() -> {
            ViewControllerHelper.smartUIUpdate(() -> this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.LOADING));
            ProfileBackupFetchResult profileBackupsInfosList = BackupApiHelper.fetchProfileBackupInfo(byteArray, profileSeed);
            ViewControllerHelper.smartUIUpdate(() -> this.profileBackupFetchStatus.set((Object)ProfileBackupFetchResult.FetchStatus.NETWORK_ERROR));
            if (!DiffUtils.areContentTheSame(profileBackupsInfosList.profileBackupsInfoList(), (List)this.profileBackupSnapshot.getValue())) {
                this.profileBackupSnapshot.postValue(profileBackupsInfosList.profileBackupsInfoList());
            }
            this.profileBackupsInfoFetchResult.set((Object)profileBackupsInfosList);
            ViewControllerHelper.smartUIUpdate(() -> {
                switch (profileBackupsInfosList.fetchStatus()) {
                    case SUCCESS: {
                        this.fetchFailed.set(false);
                        this.error.setValue(null);
                        this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.PROFILE_BACKUP_LIST_LOADED);
                        break;
                    }
                    case NETWORK_ERROR: {
                        this.fetchFailed.set(true);
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("on_boarding_flow_backup_network_error_text"), null), false));
                        break;
                    }
                    case PERMANENT_ERROR: 
                    case TRUNCATED: {
                        this.fetchFailed.set(true);
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_list_fetch_permanent_error"), null), false));
                        break;
                    }
                    case ERROR: {
                        this.fetchFailed.set(true);
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_fetch_general_error_text"), null), false));
                    }
                }
            });
        });
    }

    public void fetchDeviceBackupList() {
        AsyncTaskExecutor.submitTask(() -> {
            Optional<OwnedIdentityInfo> selectedOwnedIdentity = SelectedOwnedIdentitySingleton.getInstance().getSelectedOwnedIdentityInfo();
            if (this.seedProperty.get() != null && selectedOwnedIdentity.isPresent()) {
                ViewControllerHelper.smartUIUpdate(() -> this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.LOADING));
                DeviceBackupFetchResult deviceBackupFetchResult = BackupApiHelper.fetchDeviceBackupInfos(EngineConfiguration.getInstance().getServerName(), (String)this.seedProperty.get());
                this.deviceBackupFetchStatus.set((Object)deviceBackupFetchResult.fetchStatus());
                this.deviceBackupProfiles.postValue(deviceBackupFetchResult.deviceBackupInfos());
            }
            ViewControllerHelper.smartUIUpdate(() -> {
                switch ((DeviceBackupFetchResult.FetchStatus)((Object)((Object)((Object)this.deviceBackupFetchStatus.get())))) {
                    case SUCCESS: {
                        this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.DEVICE_BACKUP_LIST_LOADED);
                        this.error.setValue(null);
                        break;
                    }
                    case NETWORK_ERROR: {
                        this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.ERROR);
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("on_boarding_flow_backup_network_error_text"), null), false));
                        break;
                    }
                    case PERMANENT_ERROR: {
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_list_fetch_permanent_error"), null), false));
                        this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.ERROR);
                        break;
                    }
                    case ERROR: {
                        this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.ERROR);
                        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_fetch_general_error_text"), null), false));
                    }
                }
            });
        });
    }

    public boolean generateDeviceBackupSeed() {
        AsyncTaskExecutor.submitTask(() -> {
            this.logger.debug("BackupSettingsViewModel::generateDeviceBackupSeed compromised reset,regeneration needed");
            Optional<String> seed = Api.getBackupApi().generateDeviceBackupSeed(EngineConfiguration.getInstance().getServerName());
            if (seed.isPresent()) {
                ViewControllerHelper.smartUIUpdate(() -> ViewControllerHelper.smartUIUpdate(() -> this.seedProperty.setValue((String)seed.get())));
                return true;
            }
            this.logger.error("BackupSettingsViewModel::generateDeviceBackupSeed couldn't generate key ");
            ViewControllerHelper.smartUIUpdate(() -> {
                this.seedProperty.setValue(null);
                this.dataStateProp.set((Object)BackupManagementViewController.BackupManagementDataState.ERROR);
            });
            return false;
        });
        return true;
    }

    public boolean deleteDeviceBackupSeed() {
        if (this.seedProperty.get() != null) {
            Api.getBackupApi().deleteDeviceBackupSeed((String)this.seedProperty.get());
            this.seedProperty.setValue(null);
        }
        try {
            return Api.getBackupApi().getDeviceBackupSeed().isEmpty();
        }
        catch (Exception e) {
            this.logger.error("BackupSettingsViewModel::deleteDeviceBackupSeed couldn't delete key ");
            return false;
        }
    }

    public void generateBackupNow() {
        this.dataStateProp.setValue((Object)BackupManagementViewController.BackupManagementDataState.BACKUP_NOW_IN_PROGRESS);
        AsyncTaskExecutor.submitTask(() -> {
            boolean backupNowResult = Api.getBackupApi().backupDeviceAndProfilesNow();
            if (backupNowResult) {
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.dataStateProp.setValue((Object)BackupManagementViewController.BackupManagementDataState.BACKUP_NOW_SUCCESS);
                    this.error.setValue(null);
                });
            } else {
                ViewControllerHelper.smartUIUpdate(() -> {
                    this.dataStateProp.setValue((Object)BackupManagementViewController.BackupManagementDataState.ERROR);
                    NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_fetch_general_error_text"), null), false));
                });
            }
        });
    }

    public ProfileBackupFetchResult getProfileBackupsInfoFetchResult() {
        return (ProfileBackupFetchResult)this.profileBackupsInfoFetchResult.get();
    }

    public LiveData<List<DeviceBackupInfo>> getDeviceBackupProfilesLD() {
        return this.deviceBackupProfiles;
    }

    public LiveData<List<ProfileBackupsInfo>> getProfileSnapshots() {
        return this.profileBackupSnapshot;
    }
}

