/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.account;

import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.fx.framework.utils.FxButtons;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmModalController;
import io.olvid.windows.messenger.fx.settings.account.AccountSettingViewModel;
import io.olvid.windows.messenger.fx.settings.account.AccountViewContext;
import io.olvid.windows.messenger.fx.settings.account.DeleteIdentityView;
import io.olvid.windows.messenger.fx.settings.account.IAccountViewState;
import io.olvid.windows.messenger.fx.settings.account.LeaveIdentityProviderView;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.SelectedOwnedIdentitySingleton;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class AccountSettingViewController
extends BaseViewController {
    private final VBox root = new VBox(12.0);
    private final HBox accountSettingsOptionsBox = new HBox(16.0);
    private final Label subSectionLabel = new Label();
    private final DeleteIdentityView deleteIdentityView;
    private final AccountViewContext context = new AccountViewContext();
    private final LiveDataListener<IAccountViewState> contextLdListener = this::accountViewContextListener;
    private List<Region> sections;
    private LeaveIdentityProviderView leaveIdentityView;
    private Button leaveIdentityProviderBtn;
    private Runnable closeModalDelegate;
    private final AccountSettingViewModel viewModel;
    private final SimpleStringProperty titleCategoryProperty;
    private final SimpleStringProperty subTitleCategoryProperty;
    private final ObjectProperty<Runnable> backAction;

    public AccountSettingViewController(Runnable closeModalDelegate, LiveData<OwnedIdentityInfo> ownedIdentityLiveData, SimpleStringProperty titleCategoryProperty, SimpleStringProperty subTitleProperty, ObjectProperty<Runnable> backAction) {
        this.titleCategoryProperty = titleCategoryProperty;
        this.subTitleCategoryProperty = subTitleProperty;
        this.backAction = backAction;
        this.closeModalDelegate = closeModalDelegate;
        this.viewModel = new AccountSettingViewModel(ownedIdentityLiveData);
        this.leaveIdentityView = new LeaveIdentityProviderView(this::handleLeaveIdentityProvider, this.viewModel.managedRestricted);
        this.deleteIdentityView = new DeleteIdentityView(this::handleDeleteIdentityProvider);
        this.sections = new ArrayList<Region>();
        this.sections.addAll(List.of(this.accountSettingsOptionsBox, this.deleteIdentityView, this.leaveIdentityView));
        this.configureRoot();
        this.configureAccountSettingsOptions();
        this.root.getChildren().addAll((Object[])new Node[]{this.accountSettingsOptionsBox, this.deleteIdentityView, this.leaveIdentityView});
        this.context.pushState(AccountViewContext.MainState.of(false));
        this.bindLifecycle();
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        this.context.getCurrentStateLiveData().addListener(this.contextLdListener);
        this.viewModel.onAttach();
        this.leaveIdentityProviderBtn.visibleProperty().bind((ObservableValue)this.viewModel.isIdentityManaged);
        this.leaveIdentityProviderBtn.managedProperty().bind((ObservableValue)this.leaveIdentityProviderBtn.visibleProperty());
        this.leaveIdentityView.setupView();
        this.context.pushState(AccountViewContext.MainState.of(true));
        this.viewModel.ownedIdentityInfoProperty.subscribe(ownedIdentityInfo -> ViewControllerHelper.smartUIUpdate(() -> {
            if (ownedIdentityInfo == null) {
                this.subTitleCategoryProperty.set("");
                return;
            }
            this.subTitleCategoryProperty.set("(" + ownedIdentityInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST) + ")");
        }));
    }

    @Override
    public void onLayoutDetached() {
        this.context.getCurrentStateLiveData().removeListener(this.contextLdListener);
        this.viewModel.onDetach();
        this.leaveIdentityProviderBtn.visibleProperty().unbind();
        this.leaveIdentityProviderBtn.managedProperty().unbind();
        this.leaveIdentityView.cleanView();
        this.context.pushState(AccountViewContext.MainState.of(false));
    }

    private void configureAccountSettingsOptions() {
        VBox list = new VBox(8.0);
        list.setFillWidth(true);
        list.setMaxWidth(Double.MAX_VALUE);
        this.leaveIdentityProviderBtn = FxButtons.create(() -> this.context.pushState(AccountViewContext.LeaveIdentityProviderState.of())).label(ViewControllerHelper.getString("leave_identity_provider_option")).chevron(true).fullWidth().addStyleClasses("setting-left-background", "rounded-background-pane", "clickable-setting-item-round-full").addLabelStyleClasses("danger-text").visible(this.viewModel.isIdentityManaged.get()).managed(this.viewModel.isIdentityManaged.get()).build();
        list.getChildren().add((Object)this.leaveIdentityProviderBtn);
        Button deleteIdentity = FxButtons.create(() -> this.context.pushState(AccountViewContext.DeleteIdentity.of())).label(ViewControllerHelper.getString("delete_profile_option")).chevron(true).fullWidth().addStyleClasses("setting-left-background", "rounded-background-pane", "clickable-setting-item-round-full").addLabelStyleClasses("danger-text").build();
        list.getChildren().add((Object)deleteIdentity);
        this.accountSettingsOptionsBox.getChildren().setAll((Object[])new Node[]{list});
        this.accountSettingsOptionsBox.setAlignment(Pos.CENTER_LEFT);
        this.accountSettingsOptionsBox.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)list, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.accountSettingsOptionsBox, (Priority)Priority.ALWAYS);
    }

    private void onValidLeaveIdentityProvider() {
        this.context.pushState(AccountViewContext.MainState.of(true));
        this.viewModel.leaveIdentityProvider();
    }

    private void deleteOwnedIdentity(boolean deleteEverywhere) {
        this.context.pushState(AccountViewContext.MainState.of(true));
        Optional<OwnedIdentity> nextOpt = this.viewModel.deleteOwnedIdentity(deleteEverywhere);
        ViewControllerHelper.smartUIUpdate(() -> {
            this.closeModalDelegate.run();
            if (nextOpt.isEmpty()) {
                MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT));
            } else {
                SelectedOwnedIdentitySingleton.getInstance().updateCurrentIdentity((OwnedIdentity)nextOpt.get());
            }
        });
    }

    private void showOnly(Region only) {
        for (Region node : this.sections) {
            boolean on = node == only;
            node.setVisible(on);
            node.setManaged(on);
        }
    }

    private void accountViewContextListener(IAccountViewState newValue, IAccountViewState oldValue) {
        ViewControllerHelper.smartUIUpdate(() -> {
            Object target;
            IAccountViewState iAccountViewState = newValue;
            Objects.requireNonNull(iAccountViewState);
            IAccountViewState selector0$temp = iAccountViewState;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AccountViewContext.MainState.class, AccountViewContext.LeaveIdentityProviderState.class, AccountViewContext.DeleteIdentity.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    AccountViewContext.MainState ignored = (AccountViewContext.MainState)selector0$temp;
                    target = this.accountSettingsOptionsBox;
                    this.titleCategoryProperty.set(ViewControllerHelper.getString("account_settings_button_text"));
                    break;
                }
                case 1: {
                    AccountViewContext.LeaveIdentityProviderState ignored = (AccountViewContext.LeaveIdentityProviderState)selector0$temp;
                    target = this.leaveIdentityView;
                    this.subSectionLabel.setText(ViewControllerHelper.getString("leave_identity_provider_option"));
                    this.titleCategoryProperty.set(ViewControllerHelper.getString("leave_identity_provider_option"));
                    break;
                }
                case 2: {
                    AccountViewContext.DeleteIdentity ignored = (AccountViewContext.DeleteIdentity)selector0$temp;
                    this.titleCategoryProperty.set(ViewControllerHelper.getString("delete_profile_option"));
                    this.subSectionLabel.setText(ViewControllerHelper.getString("delete_profile_option"));
                    target = this.deleteIdentityView;
                }
            }
            boolean visible = !(target instanceof HBox);
            this.backAction.set((Object)(visible ? () -> this.context.pushState(AccountViewContext.MainState.of(true)) : null));
            this.showOnly((Region)target);
        });
    }

    private void configureRoot() {
        this.root.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
        this.root.setFillWidth(true);
    }

    private void handleLeaveIdentityProvider() {
        ConfirmModalController confirmModal = new ConfirmModalController(450.0);
        String titleLAbel = ViewControllerHelper.getString("leave_identity_provide_confirm_model_title");
        String descriptionLabel = ViewControllerHelper.getString("leave_identity_provide_confirm_model_description");
        String validBtnLabel = ViewControllerHelper.getString("leave_identity_provide_confirm_model_confirm_btn");
        String cancelBtnLabel = ViewControllerHelper.getString("modal.cancel");
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(validBtnLabel, List.of("button-outline", "button-outline-danger"), this::onValidLeaveIdentityProvider).asDefault(), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), () -> {}).asCancel());
        confirmModal.configure(titleLAbel, descriptionLabel, this.createTrashIcon(), actions);
        confirmModal.setBadgeKind(ConfirmModalController.BadgeKind.DANGER);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirmModal, false));
    }

    private void handleDeleteIdentityProvider() {
        ConfirmModalController confirmModal = new ConfirmModalController(450.0);
        String titleLAbel = ViewControllerHelper.getString("delete_identity_confirm_modal_title");
        String validAllBtnLabel = ViewControllerHelper.getString("delete_identity_confirm_modal_button_all");
        String validBtnLabel = ViewControllerHelper.getString("delete_identity_confirm_modal_button_this_device");
        String cancelBtnLabel = ViewControllerHelper.getString("modal.cancel");
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(validAllBtnLabel, List.of("button-outline", "button-outline-danger"), this::onValidDeleteFromAllDevices).asDefault(), ConfirmModalController.ConfirmationAction.of(validBtnLabel, List.of("button-outline"), this::onValidDeleteFromThisDevice), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), () -> {}).asCancel());
        confirmModal.configure(titleLAbel, null, this.createTrashIcon(), actions);
        confirmModal.setBadgeKind(ConfirmModalController.BadgeKind.DANGER);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirmModal, false));
    }

    private Node createTrashIcon() {
        return FxIcons.icon(FxIcons.TRASH((Paint)Color.RED, null), 20.0, 20.0);
    }

    private void onValidDeleteFromThisDevice() {
        this.deleteOwnedIdentity(false);
    }

    private void onValidDeleteFromAllDevices() {
        this.deleteOwnedIdentity(true);
    }
}

