/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings;

import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.framework.view_controller.CloseGuard;
import io.olvid.windows.messenger.fx.framework.view_controller.ViewControllerManager;
import io.olvid.windows.messenger.fx.generic_types.list_view.controller.StandardListViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.CloseableModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.settings.IdentityItem;
import io.olvid.windows.messenger.fx.settings.SettingsCategoryListCell;
import io.olvid.windows.messenger.fx.settings.SettingsModalHeader;
import io.olvid.windows.messenger.fx.settings.SettingsModalModel;
import io.olvid.windows.messenger.fx.settings.account.AccountSettingViewController;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewController;
import io.olvid.windows.messenger.fx.settings.category.ISettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.ProfileSelectorCategory;
import io.olvid.windows.messenger.fx.settings.devices.DeviceSettingViewController;
import io.olvid.windows.messenger.fx.settings.edit_identity.EditIdentitySettingViewController;
import io.olvid.windows.messenger.fx.settings.general.GeneralSettingViewController;
import io.olvid.windows.messenger.fx.settings.notifications.NotificationSettingsViewController;
import io.olvid.windows.messenger.fx.settings.update.UpdateSettingController;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class SettingsModalController
extends CloseableModalController {
    private final StackPane root = new StackPane();
    private final BorderPane borderPane = new BorderPane();
    private final SettingsModalHeader settingsModalHeader = new SettingsModalHeader();
    private final VBox settingCategoriesContainer = new VBox();
    private final StackPane settingsCategoryContentContainer = new StackPane();
    private final SettingsModalModel model = new SettingsModalModel();
    private boolean suppressCategoryReaction = false;
    private static final int BUBBLE_SIZE = 20;
    StandardListViewController<ISettingsCategory> standardListView = null;
    private final Map<ISettingsCategory.SettingCategory, Callable<BaseViewController>> controllerFactories = new HashMap<ISettingsCategory.SettingCategory, Callable<BaseViewController>>();
    ViewControllerManager<ISettingsCategory.SettingCategory> controllerManager = new ViewControllerManager(ViewControllerManager.ManagementMode.LAZY);
    private final LiveDataListener<ISettingsCategory> categoryListener = this::categoryListener;
    private final EventHandler<KeyEvent> escHandler = e -> {
        if (e.getCode() == KeyCode.ESCAPE) {
            e.consume();
            this.attemptClose();
        }
    };

    public SettingsModalController() {
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        this.controllerFactories.put(ISettingsCategory.SettingCategory.GENERAL, () -> new GeneralSettingViewController(this.model, this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty));
        this.controllerFactories.put(ISettingsCategory.SettingCategory.NOTIFICATIONS, () -> new NotificationSettingsViewController(this.model, this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty));
        this.controllerFactories.put(ISettingsCategory.SettingCategory.BACK_UPS, () -> new BackupSettingsViewController(this.model.getBackViewModel(), this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty));
        this.controllerFactories.put(ISettingsCategory.SettingCategory.UPDATE, () -> new UpdateSettingController(this.model, this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty));
        this.controllerFactories.put(ISettingsCategory.SettingCategory.EDIT_IDENTITY, () -> new EditIdentitySettingViewController(this.model.editIdentitySettingViewModel, this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty));
        this.controllerFactories.put(ISettingsCategory.SettingCategory.DEVICES, () -> new DeviceSettingViewController(this.closeModalDelegate, this.model.currentIdentityInfo, this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty));
        this.controllerFactories.put(ISettingsCategory.SettingCategory.ACCOUNT, () -> new AccountSettingViewController(this.closeModalDelegate, this.model.currentIdentityInfo, this.settingsModalHeader.settingTitleProperty, this.settingsModalHeader.settingSubTitleProperty, this.settingsModalHeader.backAction));
        this.controllerManager.registerChildrenControllers(this.controllerFactories);
        this.root.getStylesheets().add((Object)"fx/modal/settings/settings.css");
        this.settingsModalHeader.iconContainer.setOnMouseClicked(e -> this.attemptClose());
        this.standardListView = new StandardListViewController<ISettingsCategory>(param -> new SettingsOrProfileCell(this.model, identityItem -> {
            if (this.model.editIdentitySettingViewModel.hasChanges.get()) {
                this.confirmUnsavedChanges(this.getActiveCloseGuard(), () -> ViewControllerHelper.smartUIUpdate(() -> {
                    this.model.editIdentitySettingViewModel.save();
                    this.model.selectIdentity((IdentityItem)identityItem);
                }), () -> {});
            } else {
                this.model.selectIdentity((IdentityItem)identityItem);
            }
        }), this.model.categoryObservableList, this.model.listModel, (settingCategory, node) -> {
            if (!(settingCategory instanceof ProfileSelectorCategory)) {
                this.model.updateState((ISettingsCategory)settingCategory);
            }
        });
        this.standardListView.getListView().setFixedCellSize(60.0);
        this.settingCategoriesContainer.setMaxWidth(250.0);
        ListView<ISettingsCategory> listView = this.standardListView.getListView();
        listView.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(listView, (Priority)Priority.ALWAYS);
        listView.getStyleClass().setAll((Object[])new String[]{"pane-trans"});
        this.settingCategoriesContainer.getChildren().addAll((Object[])new Node[]{listView});
        this.settingCategoriesContainer.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        this.settingCategoriesContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "border-pane-bottom-left"});
        this.settingCategoriesContainer.setFillWidth(true);
        this.settingCategoriesContainer.setMaxHeight(Double.MAX_VALUE);
        this.borderPane.setLeft((Node)this.settingCategoriesContainer);
        this.borderPane.setTop((Node)this.settingsModalHeader);
        this.borderPane.setCenter((Node)this.settingsCategoryContentContainer);
        this.root.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background"});
        this.root.getChildren().addAll((Object[])new Node[]{this.borderPane});
        this.root.setMaxWidth(850.0);
        this.root.setMaxHeight(650.0);
        this.root.getStylesheets().add((Object)"fx/modal/modal.css");
        this.bindLifecycle();
        this.standardListView.getListView().getSelectionModel().selectFirst();
        this.model.updateState((ISettingsCategory)this.model.categoryObservableList.getFirst());
    }

    private void categoryListener(ISettingsCategory newValue, ISettingsCategory oldValue) {
        if (newValue == null || this.suppressCategoryReaction) {
            return;
        }
        if (newValue instanceof ProfileSelectorCategory) {
            this.suppressCategoryReaction = true;
            try {
                this.standardListView.getListView().getSelectionModel().select((Object)oldValue);
            }
            finally {
                this.suppressCategoryReaction = false;
            }
            return;
        }
        CloseGuard guard = this.getActiveCloseGuard();
        if (guard != null && guard.hasChangesProperty().get()) {
            this.confirmUnsavedChanges(guard, () -> ViewControllerHelper.smartUIUpdate(() -> {
                this.suppressCategoryReaction = true;
                try {
                    this.model.updateState(newValue);
                    ISettingsCategory target = this.model.categoryObservableList.stream().filter(c -> c.getControllerId().equals((Object)newValue.getControllerId())).findFirst().orElse(newValue);
                    this.standardListView.getListView().getSelectionModel().select((Object)target);
                    this.controllerManager.replaceView(newValue.getControllerId(), (Pane)this.settingsCategoryContentContainer, null, null);
                }
                finally {
                    this.suppressCategoryReaction = false;
                }
            }), () -> {});
            return;
        }
        ViewControllerHelper.smartUIUpdate(() -> {
            this.suppressCategoryReaction = true;
            try {
                ISettingsCategory target = this.model.categoryObservableList.stream().filter(c -> c.getControllerId().equals((Object)newValue.getControllerId())).findFirst().orElse(newValue);
                this.standardListView.getListView().getSelectionModel().select((Object)target);
                this.controllerManager.replaceView(newValue.getControllerId(), (Pane)this.settingsCategoryContentContainer, null, null);
            }
            finally {
                this.suppressCategoryReaction = false;
            }
        });
    }

    @Override
    protected CloseGuard getActiveCloseGuard() {
        BaseViewController current = this.controllerManager.getCurrentController();
        if (current instanceof CloseGuard) {
            CloseGuard cg = (CloseGuard)((Object)current);
            return cg;
        }
        return null;
    }

    @Override
    protected Optional<EventHandler<KeyEvent>> getCloseKeyEventHandler() {
        return Optional.of(this.escHandler);
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
        this.model.addContextListener(this.categoryListener);
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        this.model.removeContextListener(this.categoryListener);
    }

    private static class SettingsOrProfileCell
    extends SettingsCategoryListCell {
        private final SettingsModalModel model;
        private final HBox root = new HBox(10.0);
        private final Label title = new Label();
        private final Region spacer = new Region();
        private final ContextMenu menu = new ContextMenu();
        private final IdentityBubble identityProfilePicture = new IdentityBubble(20.0);
        private final Consumer<IdentityItem> identityItemConsumer;

        SettingsOrProfileCell(SettingsModalModel model, Consumer<IdentityItem> selectionAction) {
            this.model = model;
            this.identityItemConsumer = selectionAction;
            this.getStyleClass().removeAll((Object[])new String[]{"list-cell"});
            this.root.getStyleClass().add((Object)"bt-1");
            this.getStyleClass().addAll((Object[])new String[]{"category-list-cell"});
            this.title.getStyleClass().add((Object)"body-1");
            SvgSizeable buttonIcon = new SvgSizeable();
            buttonIcon.getStyleClass().addAll(List.of("svg-chevron", "icon-small"));
            HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
            this.root.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
            this.root.setAlignment(Pos.CENTER_LEFT);
            this.root.getChildren().addAll((Object[])new Node[]{this.identityProfilePicture, this.title, this.spacer, buttonIcon});
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
                if (this.getItem() instanceof ProfileSelectorCategory) {
                    e.consume();
                    this.buildMenu();
                    Bounds b = this.localToScreen(this.getBoundsInLocal());
                    this.menu.show((Node)this, b.getMinX(), b.getMaxY());
                }
            });
            model.currentIdentityProperty().addListener((obs, oldVal, newVal) -> this.refreshSelector(model.getOwnedIdentityInfo((IdentityItem)newVal), model.getOwnedIdentityInfo((IdentityItem)oldVal)));
            model.currentIdentityInfo.addListener(this::refreshSelector);
        }

        private void buildMenu() {
            this.menu.getItems().clear();
            for (IdentityItem it : this.model.getIdentityItems()) {
                this.menu.getItems().add((Object)this.ctx(this.model.getOwnedIdentityInfo(it), it.getDisplayName(), FxIcons.CHEVRON((Paint)Color.BLACK, null), this.identityItemConsumer));
            }
        }

        private MenuItem ctx(OwnedIdentityInfo ownedIdentityInfo, String labelText, FxIcons.IconDef icon, Consumer<IdentityItem> action) {
            CustomMenuItem mi = new CustomMenuItem();
            HBox container = new HBox(10.0);
            container.setAlignment(Pos.CENTER);
            container.setPrefWidth(228.0);
            container.setPrefHeight(50.0);
            container.setPadding(new Insets(12.0, 12.0, 12.0, 12.0));
            IdentityBubble iB = new IdentityBubble(20.0);
            BubbleUtils.setBubbleData(ownedIdentityInfo, iB);
            Label label = new Label();
            label.setText(labelText);
            label.getStyleClass().add((Object)"body-1");
            this.getChildren().add((Object)label);
            Node iconNode = FxIcons.icon(icon, 10.0, 10.0, 8.0, 8.0);
            Region spacer = new Region();
            this.getChildren().add((Object)spacer);
            container.getChildren().addAll((Object[])new Node[]{iB, label, spacer, iconNode});
            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
            mi.setOnAction(e -> action.accept(this.model.getOrCreateItem(ownedIdentityInfo)));
            mi.setContent((Node)container);
            return mi;
        }

        private void refreshSelector(OwnedIdentityInfo newVal, OwnedIdentityInfo oldVal) {
            ViewControllerHelper.smartUIUpdate(() -> {
                OwnedIdentityInfo info;
                OwnedIdentityInfo ownedIdentityInfo = info = newVal != null ? newVal : (OwnedIdentityInfo)this.model.currentIdentityInfo.getValue();
                if (info != null) {
                    this.title.setText(info.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
                    BubbleUtils.setBubbleData(info, this.identityProfilePicture);
                    return;
                }
                IdentityItem cur = this.model.getCurrentIdentity();
                if (cur != null) {
                    this.title.setText(cur.getDisplayName());
                    BubbleUtils.setBubbleData(this.model.getOwnedIdentityInfo(cur), this.identityProfilePicture);
                }
            });
        }

        @Override
        protected void updateItem(ISettingsCategory item, boolean empty) {
            super.updateItem(item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
                this.setText(null);
                return;
            }
            if (item instanceof ProfileSelectorCategory) {
                this.refreshSelector((OwnedIdentityInfo)this.model.currentIdentityInfo.getValue(), null);
                this.setGraphic((Node)this.root);
                this.setText(null);
            }
        }

        public void updateSelected(boolean selected) {
            if (this.getItem() instanceof ProfileSelectorCategory) {
                return;
            }
            super.updateSelected(selected);
        }
    }
}

