/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.category.AccountSettingCategory;
import io.olvid.windows.messenger.fx.settings.category.BackupSettingCategory;
import io.olvid.windows.messenger.fx.settings.category.DeviceSettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.EditIdentityCategory;
import io.olvid.windows.messenger.fx.settings.category.GeneralSettingCategory;
import io.olvid.windows.messenger.fx.settings.category.ISettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.NotificationSettingsCategory;
import io.olvid.windows.messenger.fx.settings.category.ProfileSelectorCategory;
import io.olvid.windows.messenger.fx.settings.category.UpdateSettingsCategory;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class SettingsCategoryListCell
extends AbstractListCell<ISettingsCategory> {
    public final HBox globalContainer = new HBox();
    public final StackPane iconContainer = new StackPane();
    public final SvgSizeable categoryIcon = new SvgSizeable();
    public final Label categoryLabel = new Label();

    public SettingsCategoryListCell() {
        this.getStyleClass().removeAll((Object[])new String[]{"list-cell"});
        this.getStyleClass().addAll((Object[])new String[]{"category-list-cell"});
        this.iconContainer.getChildren().add((Object)this.categoryIcon);
        this.categoryLabel.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.categoryLabel.setPadding(new Insets(0.0, 0.0, 0.0, 8.0));
        this.globalContainer.setPadding(new Insets(8.0, 8.0, 8.0, 8.0));
        this.globalContainer.setAlignment(Pos.CENTER_LEFT);
        this.globalContainer.getChildren().addAll((Object[])new Node[]{this.iconContainer, this.categoryLabel});
    }

    @Override
    protected void updateItem(ISettingsCategory item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.categoryIcon.getStyleClass().clear();
            this.categoryLabel.textProperty().unbind();
            this.categoryLabel.setText(null);
            this.setText(null);
            this.setGraphic(null);
            return;
        }
        this.categoryLabel.setText(ViewControllerHelper.getString(item.getTitle()));
        ISettingsCategory iSettingsCategory = item;
        Objects.requireNonNull(iSettingsCategory);
        ISettingsCategory iSettingsCategory2 = iSettingsCategory;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GeneralSettingCategory.class, NotificationSettingsCategory.class, BackupSettingCategory.class, UpdateSettingsCategory.class, EditIdentityCategory.class, DeviceSettingsCategory.class, AccountSettingCategory.class, ProfileSelectorCategory.class}, (Object)iSettingsCategory2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GeneralSettingCategory ignored = (GeneralSettingCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"svg-settings", "icon-medium"});
                break;
            }
            case 1: {
                NotificationSettingsCategory ignored = (NotificationSettingsCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"icon-bell", "icon-medium"});
                break;
            }
            case 2: {
                BackupSettingCategory ignored = (BackupSettingCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"icon-database", "icon-medium"});
                break;
            }
            case 3: {
                UpdateSettingsCategory ignored = (UpdateSettingsCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"svg-settings", "icon-medium"});
                break;
            }
            case 4: {
                EditIdentityCategory ignored = (EditIdentityCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"svg-user", "icon-medium"});
                break;
            }
            case 5: {
                DeviceSettingsCategory ignored = (DeviceSettingsCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"icon-desktop-device", "icon-medium"});
                break;
            }
            case 6: {
                AccountSettingCategory ignored = (AccountSettingCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"svg-settings", "icon-medium"});
                break;
            }
            case 7: {
                ProfileSelectorCategory ignored = (ProfileSelectorCategory)iSettingsCategory2;
                this.categoryIcon.getStyleClass().setAll((Object[])new String[]{"svg-user", "icon-medium"});
                this.globalContainer.getStyleClass().add((Object)"bt-1");
            }
        }
        this.setGraphic((Node)this.globalContainer);
    }
}

