/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings;

import io.olvid.windows.messenger.fx.settings.IdentityItem;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class IdentityListCell
extends ListCell<IdentityItem> {
    private final HBox root = new HBox(10.0);
    private final ImageView avatar = new ImageView();
    private final VBox labels = new VBox(2.0);
    private final Label title = new Label();
    private final Region spacer = new Region();
    private final Label chevron = new Label("\u25be");

    IdentityListCell() {
        this.avatar.setFitWidth(28.0);
        this.avatar.setFitHeight(28.0);
        this.avatar.setPreserveRatio(true);
        this.avatar.getStyleClass().add((Object)"profile-avatar");
        this.title.getStyleClass().add((Object)"profile-title");
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.root.getChildren().addAll((Object[])new Node[]{this.avatar, this.labels, this.spacer, this.chevron});
        this.labels.getChildren().addAll((Object[])new Node[]{this.title});
    }

    protected void updateItem(IdentityItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
            this.setText(null);
            return;
        }
        this.avatar.setImage(item.getPhoto());
        this.title.setText(item.getDisplayName());
        this.setGraphic((Node)this.root);
        this.setText(null);
    }
}

