/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.password_management;

import io.olvid.engine.secure_io.KeyManagerSingleton;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.scenes_management.AppScenesManager;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class PasswordInputController
implements Initializable {
    @FXML
    AnchorPane locked_screen_container;
    @FXML
    Label password_inout_label;
    @FXML
    PasswordField password_field;
    @FXML
    Button validation_button;
    @FXML
    Button skip_button;
    @FXML
    VBox password_form_vbox;
    private static final String passwordCreationMessage = "password_creation_message";
    private static final String passwordInput = "password_input";
    private final boolean isGenesis;
    private Consumer<String> validationConsumer;

    public PasswordInputController(boolean isGenesis) {
        this.isGenesis = isGenesis;
        if (this.isGenesis) {
            this.validationConsumer = this::passwordCreationConsumer;
            ViewControllerHelper.loadNodeWithExplicitController(this, "fx/password_management/password_input_modal.fxml");
        } else if (KeyManagerSingleton.getInstance().tryToInitKeyManagement(AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH, "")) {
            AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.INITIALIZING));
        } else {
            ViewControllerHelper.loadNodeWithExplicitController(this, "fx/password_management/password_input_modal.fxml");
            this.validationConsumer = this::passwordValidationConsumer;
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        if (this.isGenesis) {
            this.password_inout_label.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(passwordCreationMessage).replace("\n", System.lineSeparator()));
        } else {
            this.password_inout_label.setText(ViewControllerHelper.RESOURCE_BUNDLE.getString(passwordInput).replace("\n", System.lineSeparator()));
            this.skip_button.setManaged(false);
            this.skip_button.setVisible(false);
        }
        this.validation_button.setOnAction(event -> this.validationConsumer.accept(this.password_field.getText()));
        this.skip_button.setOnAction(event -> this.noPasswordConsumer());
        this.password_field.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.validationConsumer.accept(this.password_field.getText());
            }
        });
    }

    public Pane getContainer() {
        return this.locked_screen_container;
    }

    private void passwordValidationConsumer(String password) {
        boolean success = KeyManagerSingleton.getInstance().tryToInitKeyManagement(AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH, password);
        if (!success) {
            AppLogger.d("wrong password entered ?");
            this.password_field.getStyleClass().add(0, (Object)"password-field-error");
            this.password_field.setText("");
        } else {
            AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.INITIALIZING));
        }
    }

    private void passwordCreationConsumer(String password) {
        boolean success = KeyManagerSingleton.getInstance().tryToInitKeyManagement(AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH, password);
        if (!success) {
            AppLogger.e("can't initialize key manager --> exiting ..");
            Platform.exit();
        } else {
            AppScenesManager.globalAppStateContext.pushState(new AppScenesManager.GlobalAppState(AppScenesManager.AppStateType.INITIALIZING));
        }
    }

    private void noPasswordConsumer() {
        this.passwordCreationConsumer("");
    }
}

